rule elf_persirai_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects elf.persirai."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/elf.persirai"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c420 6a00 6a0d 68???????? 8b442414 }
            // n = 5, score = 100
            //   83c420               | add                 esp, 0x20
            //   6a00                 | push                0
            //   6a0d                 | push                0xd
            //   68????????           |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_1 = { 89542414 8a16 46 8d42d0 3c09 76e4 }
            // n = 6, score = 100
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   8a16                 | mov                 dl, byte ptr [esi]
            //   46                   | inc                 esi
            //   8d42d0               | lea                 eax, [edx - 0x30]
            //   3c09                 | cmp                 al, 9
            //   76e4                 | jbe                 0xffffffe6

        $sequence_2 = { c3 57 56 53 31ff 8b4c2414 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   57                   | push                edi
            //   56                   | push                esi
            //   53                   | push                ebx
            //   31ff                 | xor                 edi, edi
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]

        $sequence_3 = { 83c410 31c0 85db 740a e8???????? 8918 83c8ff }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   31c0                 | xor                 eax, eax
            //   85db                 | test                ebx, ebx
            //   740a                 | je                  0xc
            //   e8????????           |                     
            //   8918                 | mov                 dword ptr [eax], ebx
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_4 = { e8???????? 83c418 56 57 e8???????? 59 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_5 = { 8b400c e9???????? 8b4e28 898ddcdcffff 8b5e24 }
            // n = 5, score = 100
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   e9????????           |                     
            //   8b4e28               | mov                 ecx, dword ptr [esi + 0x28]
            //   898ddcdcffff         | mov                 dword ptr [ebp - 0x2324], ecx
            //   8b5e24               | mov                 ebx, dword ptr [esi + 0x24]

        $sequence_6 = { 83c410 85db 7405 3b5f10 72e5 8b4654 }
            // n = 6, score = 100
            //   83c410               | add                 esp, 0x10
            //   85db                 | test                ebx, ebx
            //   7405                 | je                  7
            //   3b5f10               | cmp                 ebx, dword ptr [edi + 0x10]
            //   72e5                 | jb                  0xffffffe7
            //   8b4654               | mov                 eax, dword ptr [esi + 0x54]

        $sequence_7 = { 8d50a9 09da eba9 8a06 3c39 8d50d0 7e10 }
            // n = 7, score = 100
            //   8d50a9               | lea                 edx, [eax - 0x57]
            //   09da                 | or                  edx, ebx
            //   eba9                 | jmp                 0xffffffab
            //   8a06                 | mov                 al, byte ptr [esi]
            //   3c39                 | cmp                 al, 0x39
            //   8d50d0               | lea                 edx, [eax - 0x30]
            //   7e10                 | jle                 0x12

        $sequence_8 = { 83c41c c3 53 8b5a18 eb0d 3b5918 }
            // n = 6, score = 100
            //   83c41c               | add                 esp, 0x1c
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   8b5a18               | mov                 ebx, dword ptr [edx + 0x18]
            //   eb0d                 | jmp                 0xf
            //   3b5918               | cmp                 ebx, dword ptr [ecx + 0x18]

        $sequence_9 = { 8d41be 3c16 770c 25ff000000 ff248560790508 0fbed2 }
            // n = 6, score = 100
            //   8d41be               | lea                 eax, [ecx - 0x42]
            //   3c16                 | cmp                 al, 0x16
            //   770c                 | ja                  0xe
            //   25ff000000           | and                 eax, 0xff
            //   ff248560790508       | jmp                 dword ptr [eax*4 + 0x8057960]
            //   0fbed2               | movsx               edx, dl

    condition:
        7 of them and filesize < 229376
}