rule osx_applejeus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.applejeus"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d9d90f1ffff 0f294370 0f294360 0f294350 0f294340 }
            // n = 5, score = 100
            //   8d9d90f1ffff         | lea                 ebx, [ebp - 0xe70]
            //   0f294370             | movaps              xmmword ptr [ebx + 0x70], xmm0
            //   0f294360             | movaps              xmmword ptr [ebx + 0x60], xmm0
            //   0f294350             | movaps              xmmword ptr [ebx + 0x50], xmm0
            //   0f294340             | movaps              xmmword ptr [ebx + 0x40], xmm0

        $sequence_1 = { e8???????? 49 89c7 bf00000300 e8???????? 49 89c6 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   49                   | dec                 ecx
            //   89c7                 | mov                 edi, eax
            //   bf00000300           | mov                 edi, 0x30000
            //   e8????????           |                     
            //   49                   | dec                 ecx
            //   89c6                 | mov                 esi, eax

        $sequence_2 = { 0f294310 0f2903 48 8d3586120000 48 }
            // n = 5, score = 100
            //   0f294310             | movaps              xmmword ptr [ebx + 0x10], xmm0
            //   0f2903               | movaps              xmmword ptr [ebx], xmm0
            //   48                   | dec                 eax
            //   8d3586120000         | lea                 esi, [0x1286]
            //   48                   | dec                 eax

        $sequence_3 = { 0f294730 41 0f294720 41 }
            // n = 4, score = 100
            //   0f294730             | movaps              xmmword ptr [edi + 0x30], xmm0
            //   41                   | inc                 ecx
            //   0f294720             | movaps              xmmword ptr [edi + 0x20], xmm0
            //   41                   | inc                 ecx

        $sequence_4 = { 89f7 e8???????? 48 8d35cb140000 48 8d9590f3ffff }
            // n = 6, score = 100
            //   89f7                 | mov                 edi, esi
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   8d35cb140000         | lea                 esi, [0x14cb]
            //   48                   | dec                 eax
            //   8d9590f3ffff         | lea                 edx, [ebp - 0xc70]

        $sequence_5 = { 03bdc0fbfcff 41 81fe00000300 0f8380000000 49 }
            // n = 5, score = 100
            //   03bdc0fbfcff         | add                 edi, dword ptr [ebp - 0x30440]
            //   41                   | inc                 ecx
            //   81fe00000300         | cmp                 esi, 0x30000
            //   0f8380000000         | jae                 0x86
            //   49                   | dec                 ecx

        $sequence_6 = { 89e7 ff15???????? 48 8bbd48f1ffff 48 }
            // n = 5, score = 100
            //   89e7                 | mov                 edi, esp
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8bbd48f1ffff         | mov                 edi, dword ptr [ebp - 0xeb8]
            //   48                   | dec                 eax

        $sequence_7 = { 89f7 e8???????? 48 89c6 31c0 }
            // n = 5, score = 100
            //   89f7                 | mov                 edi, esi
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   89c6                 | mov                 esi, eax
            //   31c0                 | xor                 eax, eax

        $sequence_8 = { 4c 89e7 48 8d35c6090000 e8???????? 84c0 }
            // n = 6, score = 100
            //   4c                   | dec                 esp
            //   89e7                 | mov                 edi, esp
            //   48                   | dec                 eax
            //   8d35c6090000         | lea                 esi, [0x9c6]
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_9 = { 83c706 e8???????? 89c3 4c 8dbdccfbffff }
            // n = 5, score = 100
            //   83c706               | add                 edi, 6
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   4c                   | dec                 esp
            //   8dbdccfbffff         | lea                 edi, [ebp - 0x434]

    condition:
        7 of them and filesize < 78336
}