rule win_acehash_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.acehash."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acehash"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 448b4630 488bd6 482b5738 4883c230 48c1fa02 482bd3 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   448b4630             | or                  edx, eax
            //   488bd6               | movzx               eax, byte ptr [ebp + 0x16]
            //   482b5738             | movzx               eax, byte ptr [ebp + 0x16]
            //   4883c230             | shr                 edx, 0x18
            //   48c1fa02             | inc                 ecx
            //   482bd3               | shl                 edx, 8

        $sequence_1 = { 488d542420 488d4c2420 4d8bc4 e8???????? 0fb6442421 }
            // n = 5, score = 200
            //   488d542420           | add                 esp, 0x10
            //   488d4c2420           | xor                 ecx, ecx
            //   4d8bc4               | movzx               ebx, al
            //   e8????????           |                     
            //   0fb6442421           | mov                 edx, ebx

        $sequence_2 = { 448955a7 438b8ca1a0e90300 43338ca9a0ed0300 43338c81a0ed0300 33ce 43338cb9a0e50300 43338cb1a0f10300 }
            // n = 7, score = 200
            //   448955a7             | xor                 eax, eax
            //   438b8ca1a0e90300     | dec                 eax
            //   43338ca9a0ed0300     | add                 esp, 0x38
            //   43338c81a0ed0300     | pop                 edi
            //   33ce                 | dec                 eax
            //   43338cb9a0e50300     | mov                 edx, dword ptr [edx]
            //   43338cb1a0f10300     | dec                 eax

        $sequence_3 = { 418bc1 4533460c c1e808 0fb6d0 418bc2 418bbc9770a10400 c1e810 }
            // n = 7, score = 200
            //   418bc1               | je                  0x19a7
            //   4533460c             | dec                 eax
            //   c1e808               | lea                 ecx, [0x37677]
            //   0fb6d0               | test                eax, eax
            //   418bc2               | dec                 eax
            //   418bbc9770a10400     | and                 dword ptr [ecx + 8], 0
            //   c1e810               | dec                 eax

        $sequence_4 = { 4803d0 8d45fa 4863c8 483bd1 7224 4c8d4c2430 }
            // n = 6, score = 200
            //   4803d0               | dec                 eax
            //   8d45fa               | mov                 ecx, dword ptr [esp + 0x60]
            //   4863c8               | dec                 esp
            //   483bd1               | mov                 edi, dword ptr [esp + 0x2c0]
            //   7224                 | dec                 eax
            //   4c8d4c2430           | mov                 ebx, dword ptr [esp + 0x318]

        $sequence_5 = { 25003f0000 418bc8 83e13f 8913 4181e000f00300 c1e104 }
            // n = 6, score = 200
            //   25003f0000           | dec                 eax
            //   418bc8               | arpl                dx, bx
            //   83e13f               | dec                 esp
            //   8913                 | mov                 esi, ecx
            //   4181e000f00300       | dec                 eax
            //   c1e104               | mov                 dword ptr [esp + 0x20], edi

        $sequence_6 = { 4883ec20 488bd9 e8???????? 488d050b8d0300 488903 488bc3 4883c420 }
            // n = 7, score = 200
            //   4883ec20             | mov                 ebp, ebx
            //   488bd9               | dec                 eax
            //   e8????????           |                     
            //   488d050b8d0300       | mov                 edx, esi
            //   488903               | dec                 eax
            //   488bc3               | sub                 edx, eax
            //   4883c420             | dec                 eax

        $sequence_7 = { 0fb6c0 45339c86a0c40300 4503cb 418bc1 48c1e810 0fb6d0 418bc1 }
            // n = 7, score = 200
            //   0fb6c0               | mov                 eax, dword ptr [eax - 8]
            //   45339c86a0c40300     | and                 dword ptr [esp + 0x30], 0
            //   4503cb               | inc                 esp
            //   418bc1               | mov                 dword ptr [esp + 0x28], eax
            //   48c1e810             | mov                 dword ptr [esp + 0x20], 0x40
            //   0fb6d0               | inc                 esp
            //   418bc1               | mov                 ecx, edx

        $sequence_8 = { 4c8d2d54051000 413bc0 7554 486303 4869c0b0000000 4e8b542870 4d85d2 }
            // n = 7, score = 200
            //   4c8d2d54051000       | cmp                 eax, 0x57
            //   413bc0               | jne                 0x6b0
            //   7554                 | dec                 eax
            //   486303               | lea                 ecx, [0x2dcd0]
            //   4869c0b0000000       | jne                 0x507
            //   4e8b542870           | dec                 eax
            //   4d85d2               | lea                 ecx, [0x32a6b]

        $sequence_9 = { c3 4053 4883ec20 488bd9 488d4c2430 ba02000000 e8???????? }
            // n = 7, score = 200
            //   c3                   | inc                 ecx
            //   4053                 | mov                 byte ptr [eax - 1], al
            //   4883ec20             | inc                 edx
            //   488bd9               | cmp                 byte ptr [ecx + esi], 0
            //   488d4c2430           | jne                 0x346
            //   ba02000000           | movzx               ecx, byte ptr [eax]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2318336
}