rule win_acridrain_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.acridrain."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.acridrain"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff37 e8???????? 83c40c 8945e4 85c0 7421 6a30 }
            // n = 7, score = 200
            //   ff37                 | push                dword ptr [edi]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   85c0                 | test                eax, eax
            //   7421                 | je                  0x23
            //   6a30                 | push                0x30

        $sequence_1 = { e9???????? 8b8538d2ffff 8b8d3cd2ffff 8bbd4cd2ffff 8b9594d2ffff 898590d2ffff 8b8550d2ffff }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8b8538d2ffff         | mov                 eax, dword ptr [ebp - 0x2dc8]
            //   8b8d3cd2ffff         | mov                 ecx, dword ptr [ebp - 0x2dc4]
            //   8bbd4cd2ffff         | mov                 edi, dword ptr [ebp - 0x2db4]
            //   8b9594d2ffff         | mov                 edx, dword ptr [ebp - 0x2d6c]
            //   898590d2ffff         | mov                 dword ptr [ebp - 0x2d70], eax
            //   8b8550d2ffff         | mov                 eax, dword ptr [ebp - 0x2db0]

        $sequence_2 = { c744881000000000 eb32 8b16 807a4100 752a 8b4708 8d0c80 }
            // n = 7, score = 200
            //   c744881000000000     | mov                 dword ptr [eax + ecx*4 + 0x10], 0
            //   eb32                 | jmp                 0x34
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   807a4100             | cmp                 byte ptr [edx + 0x41], 0
            //   752a                 | jne                 0x2c
            //   8b4708               | mov                 eax, dword ptr [edi + 8]
            //   8d0c80               | lea                 ecx, [eax + eax*4]

        $sequence_3 = { be???????? e8???????? 83c408 85c0 0f84a6000000 5f 5e }
            // n = 7, score = 200
            //   be????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f84a6000000         | je                  0xac
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_4 = { ff7514 51 e8???????? 83c418 33c0 5f 8be5 }
            // n = 7, score = 200
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   8be5                 | mov                 esp, ebp

        $sequence_5 = { ff30 8b442420 0534030000 50 e8???????? 83c408 8bd8 }
            // n = 7, score = 200
            //   ff30                 | push                dword ptr [eax]
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   0534030000           | add                 eax, 0x334
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8bd8                 | mov                 ebx, eax

        $sequence_6 = { 7fc5 8b4510 8b4d08 99 034514 5f 135518 }
            // n = 7, score = 200
            //   7fc5                 | jg                  0xffffffc7
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   99                   | cdq                 
            //   034514               | add                 eax, dword ptr [ebp + 0x14]
            //   5f                   | pop                 edi
            //   135518               | adc                 edx, dword ptr [ebp + 0x18]

        $sequence_7 = { 8d4705 8b7c2428 03f8 897c2428 13ee ff15???????? 8d44241c }
            // n = 7, score = 200
            //   8d4705               | lea                 eax, [edi + 5]
            //   8b7c2428             | mov                 edi, dword ptr [esp + 0x28]
            //   03f8                 | add                 edi, eax
            //   897c2428             | mov                 dword ptr [esp + 0x28], edi
            //   13ee                 | adc                 ebp, esi
            //   ff15????????         |                     
            //   8d44241c             | lea                 eax, [esp + 0x1c]

        $sequence_8 = { ff7504 55 e8???????? 83c40c 85c0 742b 8b4704 }
            // n = 7, score = 200
            //   ff7504               | push                dword ptr [ebp + 4]
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   742b                 | je                  0x2d
            //   8b4704               | mov                 eax, dword ptr [edi + 4]

        $sequence_9 = { 8bf8 ff15???????? 83c410 85ff 0f84bb000000 8bc7 5f }
            // n = 7, score = 200
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   85ff                 | test                edi, edi
            //   0f84bb000000         | je                  0xc1
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 2244608
}