rule win_akira_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.akira."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.akira"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 488d8a58000000 e9???????? 4889542410 55 4883ec40 488bea }
            // n = 7, score = 200
            //   e9????????           |                     
            //   488d8a58000000       | dec                 eax
            //   e9????????           |                     
            //   4889542410           | lea                 ecx, [ebp + 0x6d5]
            //   55                   | dec                 eax
            //   4883ec40             | mov                 edx, eax
            //   488bea               | mov                 byte ptr [ebp + 0x6dd], 0x79

        $sequence_1 = { c1fa06 8bc2 c1e81f 03d0 6bc27f 2bc8 42888c05cb020000 }
            // n = 7, score = 200
            //   c1fa06               | dec                 edx
            //   8bc2                 | movsx               eax, byte ptr [ecx + ebx + 0x6b190]
            //   c1e81f               | mov                 eax, dword ptr [ebx + 0xc]
            //   03d0                 | cmp                 dword ptr [edi + 0xc], eax
            //   6bc27f               | jne                 0x20e
            //   2bc8                 | mov                 al, 1
            //   42888c05cb020000     | dec                 eax

        $sequence_2 = { 488d4b28 e8???????? 66837b0a00 7413 bab0000000 488bcb e8???????? }
            // n = 7, score = 200
            //   488d4b28             | dec                 eax
            //   e8????????           |                     
            //   66837b0a00           | lea                 eax, [ecx + 1]
            //   7413                 | dec                 eax
            //   bab0000000           | mov                 dword ptr [ebp - 0x11], eax
            //   488bcb               | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { f30f7f442430 33d2 488d4c2430 e8???????? 498b4f18 48394d28 0f854f010000 }
            // n = 7, score = 200
            //   f30f7f442430         | lea                 eax, [ebx + 1]
            //   33d2                 | dec                 eax
            //   488d4c2430           | cmp                 ebx, -1
            //   e8????????           |                     
            //   498b4f18             | dec                 eax
            //   48394d28             | cmove               eax, ebx
            //   0f854f010000         | dec                 eax

        $sequence_4 = { e8???????? 48895f08 ba18000000 488bcf e8???????? 488d4dd8 ff15???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   48895f08             | mov                 byte ptr [ebp + 0x24b], 0x74
            //   ba18000000           | mov                 byte ptr [ebp + 0x24c], 0x6e
            //   488bcf               | mov                 byte ptr [ebp + 0x24d], 0x32
            //   e8????????           |                     
            //   488d4dd8             | mov                 byte ptr [ebp + 0x24e], 0x6e
            //   ff15????????         |                     

        $sequence_5 = { ff5020 88442430 0f57c0 0f11459f 48c745af01000000 41bf0f000000 4c897db7 }
            // n = 7, score = 200
            //   ff5020               | dec                 eax
            //   88442430             | mov                 eax, ebx
            //   0f57c0               | dec                 eax
            //   0f11459f             | add                 esp, 0x50
            //   48c745af01000000     | pop                 ebx
            //   41bf0f000000         | ret                 
            //   4c897db7             | dec                 eax

        $sequence_6 = { 4584ed 7444 498d5eff 488b75df 483bde 7425 e8???????? }
            // n = 7, score = 200
            //   4584ed               | dec                 ecx
            //   7444                 | mov                 dword ptr [ecx + 8], edx
            //   498d5eff             | inc                 ecx
            //   488b75df             | mov                 dword ptr [ecx + 0x24], eax
            //   483bde               | movzx               ecx, byte ptr [edx]
            //   7425                 | and                 ecx, 0xf
            //   e8????????           |                     

        $sequence_7 = { 66660f1f840000000000 49ffc0 6642833c4000 75f5 488d9539030000 488d8de0150000 e8???????? }
            // n = 7, score = 200
            //   66660f1f840000000000     | jne    0xc35
            //   49ffc0               | dec                 eax
            //   6642833c4000         | lea                 edx, [esp + 0x21]
            //   75f5                 | dec                 eax
            //   488d9539030000       | lea                 ecx, [ebp + 0x30]
            //   488d8de0150000       | dec                 esp
            //   e8????????           |                     

        $sequence_8 = { 41884640 41c6464101 498b0c24 48894c2430 4885c9 7445 488b5770 }
            // n = 7, score = 200
            //   41884640             | inc                 ecx
            //   41c6464101           | mov                 byte ptr [esi], 0x2d
            //   498b0c24             | dec                 ebp
            //   48894c2430           | lea                 edi, [esi + 1]
            //   4885c9               | dec                 eax
            //   7445                 | mov                 ecx, dword ptr [edi]
            //   488b5770             | dec                 eax

        $sequence_9 = { 7508 c60330 48ffcb ebdf fec1 880b 483bde }
            // n = 7, score = 200
            //   7508                 | dec                 eax
            //   c60330               | lea                 ecx, [0x8bcb9]
            //   48ffcb               | dec                 eax
            //   ebdf                 | mov                 eax, dword ptr [0x58]
            //   fec1                 | mov                 edx, 4
            //   880b                 | dec                 eax
            //   483bde               | mov                 ecx, dword ptr [eax]

    condition:
        7 of them and filesize < 1286144
}