rule win_amadey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.amadey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.amadey"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837e1410 7202 8b3e 8a0402 88040f 41 }
            // n = 6, score = 900
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   8a0402               | mov                 al, byte ptr [edx + eax]
            //   88040f               | mov                 byte ptr [edi + ecx], al
            //   41                   | inc                 ecx

        $sequence_1 = { 83f802 7427 e8???????? 83f810 }
            // n = 4, score = 900
            //   83f802               | cmp                 eax, 2
            //   7427                 | je                  0x29
            //   e8????????           |                     
            //   83f810               | cmp                 eax, 0x10

        $sequence_2 = { 83c408 83ec18 8bf4 83ec18 8bcc 68???????? }
            // n = 6, score = 900
            //   83c408               | add                 esp, 8
            //   83ec18               | sub                 esp, 0x18
            //   8bf4                 | mov                 esi, esp
            //   83ec18               | sub                 esp, 0x18
            //   8bcc                 | mov                 ecx, esp
            //   68????????           |                     

        $sequence_3 = { 8b10 ff7010 837d4c10 8d4d38 8b7548 0f434d38 }
            // n = 6, score = 900
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   ff7010               | push                dword ptr [eax + 0x10]
            //   837d4c10             | cmp                 dword ptr [ebp + 0x4c], 0x10
            //   8d4d38               | lea                 ecx, [ebp + 0x38]
            //   8b7548               | mov                 esi, dword ptr [ebp + 0x48]
            //   0f434d38             | cmovae              ecx, dword ptr [ebp + 0x38]

        $sequence_4 = { 83caff 8b4508 8bc8 83781410 7202 8b08 }
            // n = 6, score = 900
            //   83caff               | or                  edx, 0xffffffff
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bc8                 | mov                 ecx, eax
            //   83781410             | cmp                 dword ptr [eax + 0x14], 0x10
            //   7202                 | jb                  4
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_5 = { 83f801 7431 e8???????? 83f802 7427 }
            // n = 5, score = 900
            //   83f801               | cmp                 eax, 1
            //   7431                 | je                  0x33
            //   e8????????           |                     
            //   83f802               | cmp                 eax, 2
            //   7427                 | je                  0x29

        $sequence_6 = { 8bcc 68???????? e8???????? 8d4db4 e8???????? }
            // n = 5, score = 900
            //   8bcc                 | mov                 ecx, esp
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   e8????????           |                     

        $sequence_7 = { 68???????? e8???????? 8d4dcc e8???????? 83c418 }
            // n = 5, score = 900
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

        $sequence_8 = { 68???????? e8???????? 8d4d98 e8???????? 83c418 }
            // n = 5, score = 800
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

        $sequence_9 = { 722f 8b8d78feffff 42 8bc1 81fa00100000 }
            // n = 5, score = 800
            //   722f                 | jb                  0x31
            //   8b8d78feffff         | mov                 ecx, dword ptr [ebp - 0x188]
            //   42                   | inc                 edx
            //   8bc1                 | mov                 eax, ecx
            //   81fa00100000         | cmp                 edx, 0x1000

        $sequence_10 = { 8985f4fbffff 8b85ecfbffff c1e002 8985f0fbffff 8b85f4fbffff 890424 e8???????? }
            // n = 7, score = 700
            //   8985f4fbffff         | mov                 dword ptr [ebp - 0x40c], eax
            //   8b85ecfbffff         | mov                 eax, dword ptr [ebp - 0x414]
            //   c1e002               | shl                 eax, 2
            //   8985f0fbffff         | mov                 dword ptr [ebp - 0x410], eax
            //   8b85f4fbffff         | mov                 eax, dword ptr [ebp - 0x40c]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_11 = { e8???????? c7442404???????? 8d85e8feffff 890424 e8???????? 8d85e8feffff 890424 }
            // n = 7, score = 700
            //   e8????????           |                     
            //   c7442404????????     |                     
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_12 = { c70424???????? e8???????? 8b45fc 89442408 c7442404???????? }
            // n = 5, score = 700
            //   c70424????????       |                     
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c7442404????????     |                     

        $sequence_13 = { 8d85f8fdffff 890424 e8???????? c744240800020000 c744240400000000 }
            // n = 5, score = 700
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   c744240800020000     | mov                 dword ptr [esp + 8], 0x200
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_14 = { 50 68???????? 83ec18 8bcc 68???????? }
            // n = 5, score = 700
            //   50                   | push                eax
            //   68????????           |                     
            //   83ec18               | sub                 esp, 0x18
            //   8bcc                 | mov                 ecx, esp
            //   68????????           |                     

        $sequence_15 = { e8???????? 8985f4dfffff 83bdf4dfffff00 742c }
            // n = 4, score = 700
            //   e8????????           |                     
            //   8985f4dfffff         | mov                 dword ptr [ebp - 0x200c], eax
            //   83bdf4dfffff00       | cmp                 dword ptr [ebp - 0x200c], 0
            //   742c                 | je                  0x2e

        $sequence_16 = { 8945f4 eb05 ff4508 eba7 8b45f4 }
            // n = 5, score = 700
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   eb05                 | jmp                 7
            //   ff4508               | inc                 dword ptr [ebp + 8]
            //   eba7                 | jmp                 0xffffffa9
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_17 = { 890424 e8???????? 89442404 8d85f8f9ffff 890424 e8???????? }
            // n = 6, score = 700
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8d85f8f9ffff         | lea                 eax, [ebp - 0x608]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_18 = { eb0a c705????????04000000 83bd5cffffff06 7525 83bd60ffffff02 }
            // n = 5, score = 700
            //   eb0a                 | jmp                 0xc
            //   c705????????04000000     |     
            //   83bd5cffffff06       | cmp                 dword ptr [ebp - 0xa4], 6
            //   7525                 | jne                 0x27
            //   83bd60ffffff02       | cmp                 dword ptr [ebp - 0xa0], 2

        $sequence_19 = { 56 57 8b3d???????? 83ec18 }
            // n = 4, score = 700
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   83ec18               | sub                 esp, 0x18

        $sequence_20 = { 51 e8???????? 83c408 8b9514feffff }
            // n = 4, score = 600
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b9514feffff         | mov                 edx, dword ptr [ebp - 0x1ec]

    condition:
        7 of them and filesize < 908288
}