rule win_apocalipto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.apocalipto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.apocalipto"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 31d2 90 8a0c16 880c10 42 39d3 }
            // n = 6, score = 100
            //   31d2                 | xor                 edx, edx
            //   90                   | nop                 
            //   8a0c16               | mov                 cl, byte ptr [esi + edx]
            //   880c10               | mov                 byte ptr [eax + edx], cl
            //   42                   | inc                 edx
            //   39d3                 | cmp                 ebx, edx

        $sequence_1 = { 893424 ff15???????? 57 8b85c8feffff 8d65f4 }
            // n = 5, score = 100
            //   893424               | mov                 dword ptr [esp], esi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8b85c8feffff         | mov                 eax, dword ptr [ebp - 0x138]
            //   8d65f4               | lea                 esp, [ebp - 0xc]

        $sequence_2 = { 89442408 8b4310 89442404 8d85e0f3ffff 890424 e8???????? }
            // n = 6, score = 100
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8d85e0f3ffff         | lea                 eax, [ebp - 0xc20]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_3 = { 85c0 0f845a090000 c7442404???????? 891c24 ff15???????? 83ec08 a3???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f845a090000         | je                  0x960
            //   c7442404????????     |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   ff15????????         |                     
            //   83ec08               | sub                 esp, 8
            //   a3????????           |                     

        $sequence_4 = { 40 3d00010000 75f4 31ff 31c9 }
            // n = 5, score = 100
            //   40                   | inc                 eax
            //   3d00010000           | cmp                 eax, 0x100
            //   75f4                 | jne                 0xfffffff6
            //   31ff                 | xor                 edi, edi
            //   31c9                 | xor                 ecx, ecx

        $sequence_5 = { 890424 ff15???????? 83ec0c 85c0 7504 31c0 }
            // n = 6, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   ff15????????         |                     
            //   83ec0c               | sub                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   31c0                 | xor                 eax, eax

        $sequence_6 = { 83ec08 a3???????? 85c0 0f8480070000 c7442404???????? }
            // n = 5, score = 100
            //   83ec08               | sub                 esp, 8
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8480070000         | je                  0x786
            //   c7442404????????     |                     

        $sequence_7 = { 29f2 89542404 893c24 e8???????? c745e400000000 }
            // n = 5, score = 100
            //   29f2                 | sub                 edx, esi
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   893c24               | mov                 dword ptr [esp], edi
            //   e8????????           |                     
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0

        $sequence_8 = { 8b463c 8d1406 895580 8d8406f8000000 0fb74a06 85c9 0f8456020000 }
            // n = 7, score = 100
            //   8b463c               | mov                 eax, dword ptr [esi + 0x3c]
            //   8d1406               | lea                 edx, [esi + eax]
            //   895580               | mov                 dword ptr [ebp - 0x80], edx
            //   8d8406f8000000       | lea                 eax, [esi + eax + 0xf8]
            //   0fb74a06             | movzx               ecx, word ptr [edx + 6]
            //   85c9                 | test                ecx, ecx
            //   0f8456020000         | je                  0x25c

        $sequence_9 = { 83ec08 a3???????? 85c0 0f843b0b0000 c7442404???????? 891c24 ff15???????? }
            // n = 7, score = 100
            //   83ec08               | sub                 esp, 8
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   0f843b0b0000         | je                  0xb41
            //   c7442404????????     |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 212992
}