rule win_ardamax_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ardamax"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 21ff 1d2421ff1c 2422 ff1c24 }
            // n = 4, score = 100
            //   21ff                 | and                 edi, edi
            //   1d2421ff1c           | sbb                 eax, 0x1cff2124
            //   2422                 | and                 al, 0x22
            //   ff1c24               | lcall               [esp]

        $sequence_1 = { 4c 9d ee c2534f 8508 04c2 e423 }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   9d                   | popfd               
            //   ee                   | out                 dx, al
            //   c2534f               | ret                 0x4f53
            //   8508                 | test                dword ptr [eax], ecx
            //   04c2                 | add                 al, 0xc2
            //   e423                 | in                  al, 0x23

        $sequence_2 = { ff1b 2321 ff1c24 21ff }
            // n = 4, score = 100
            //   ff1b                 | lcall               [ebx]
            //   2321                 | and                 esp, dword ptr [ecx]
            //   ff1c24               | lcall               [esp]
            //   21ff                 | and                 edi, edi

        $sequence_3 = { 7548 6a86 55 b8e2f5d830 }
            // n = 4, score = 100
            //   7548                 | jne                 0x4a
            //   6a86                 | push                -0x7a
            //   55                   | push                ebp
            //   b8e2f5d830           | mov                 eax, 0x30d8f5e2

        $sequence_4 = { ff18 1b1b ff12 1313 ff0e }
            // n = 5, score = 100
            //   ff18                 | lcall               [eax]
            //   1b1b                 | sbb                 ebx, dword ptr [ebx]
            //   ff12                 | call                dword ptr [edx]
            //   1313                 | adc                 edx, dword ptr [ebx]
            //   ff0e                 | dec                 dword ptr [esi]

        $sequence_5 = { 55 b8e2f5d830 a0???????? 51 88a38fd2e177 }
            // n = 5, score = 100
            //   55                   | push                ebp
            //   b8e2f5d830           | mov                 eax, 0x30d8f5e2
            //   a0????????           |                     
            //   51                   | push                ecx
            //   88a38fd2e177         | mov                 byte ptr [ebx + 0x77e1d28f], ah

        $sequence_6 = { 150ca0756b 3203 5c 1282aaea7c7c fc 890d???????? }
            // n = 6, score = 100
            //   150ca0756b           | adc                 eax, 0x6b75a00c
            //   3203                 | xor                 al, byte ptr [ebx]
            //   5c                   | pop                 esp
            //   1282aaea7c7c         | adc                 al, byte ptr [edx + 0x7c7ceaaa]
            //   fc                   | cld                 
            //   890d????????         |                     

        $sequence_7 = { de4738 1c2e 4d a5 8c17 1389f83e5aaa 8530 }
            // n = 7, score = 100
            //   de4738               | fiadd               word ptr [edi + 0x38]
            //   1c2e                 | sbb                 al, 0x2e
            //   4d                   | dec                 ebp
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   8c17                 | mov                 word ptr [edi], ss
            //   1389f83e5aaa         | adc                 ecx, dword ptr [ecx - 0x55a5c108]
            //   8530                 | test                dword ptr [eax], esi

        $sequence_8 = { 35df8b2bcf ee 837d46d8 f8 c41e }
            // n = 5, score = 100
            //   35df8b2bcf           | xor                 eax, 0xcf2b8bdf
            //   ee                   | out                 dx, al
            //   837d46d8             | cmp                 dword ptr [ebp + 0x46], -0x28
            //   f8                   | clc                 
            //   c41e                 | les                 ebx, ptr [esi]

        $sequence_9 = { 22ff 1d2322ff1d 2422 ff1d2422ff1d 2422 ff1d2522ff1d }
            // n = 6, score = 100
            //   22ff                 | and                 bh, bh
            //   1d2322ff1d           | sbb                 eax, 0x1dff2223
            //   2422                 | and                 al, 0x22
            //   ff1d2422ff1d         | lcall               [0x1dff2224]
            //   2422                 | and                 al, 0x22
            //   ff1d2522ff1d         | lcall               [0x1dff2225]

    condition:
        7 of them and filesize < 630784
}