rule win_artfulpie_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.artfulpie."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.artfulpie"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1f906 53 6bd830 56 8b048d984e4100 57 8b7d10 }
            // n = 7, score = 200
            //   c1f906               | sar                 ecx, 6
            //   53                   | push                ebx
            //   6bd830               | imul                ebx, eax, 0x30
            //   56                   | push                esi
            //   8b048d984e4100       | mov                 eax, dword ptr [ecx*4 + 0x414e98]
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]

        $sequence_1 = { 33ff 3b7e0c 7d32 8b4608 }
            // n = 4, score = 200
            //   33ff                 | xor                 edi, edi
            //   3b7e0c               | cmp                 edi, dword ptr [esi + 0xc]
            //   7d32                 | jge                 0x34
            //   8b4608               | mov                 eax, dword ptr [esi + 8]

        $sequence_2 = { 03f1 53 8b413c 03c7 8b7dfc }
            // n = 5, score = 200
            //   03f1                 | add                 esi, ecx
            //   53                   | push                ebx
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]
            //   03c7                 | add                 eax, edi
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]

        $sequence_3 = { b8b42b0000 e8???????? 0f2805???????? 8bc2 0f118558ffffff 56 }
            // n = 6, score = 200
            //   b8b42b0000           | mov                 eax, 0x2bb4
            //   e8????????           |                     
            //   0f2805????????       |                     
            //   8bc2                 | mov                 eax, edx
            //   0f118558ffffff       | movups              xmmword ptr [ebp - 0xa8], xmm0
            //   56                   | push                esi

        $sequence_4 = { 89861c020000 8b45e0 8d4e0c 6a06 8d9004424100 5f 668b02 }
            // n = 7, score = 200
            //   89861c020000         | mov                 dword ptr [esi + 0x21c], eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8d4e0c               | lea                 ecx, [esi + 0xc]
            //   6a06                 | push                6
            //   8d9004424100         | lea                 edx, [eax + 0x414204]
            //   5f                   | pop                 edi
            //   668b02               | mov                 ax, word ptr [edx]

        $sequence_5 = { e8???????? 83a6984e410000 59 83c604 81fe00020000 72dd b001 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83a6984e410000       | and                 dword ptr [esi + 0x414e98], 0
            //   59                   | pop                 ecx
            //   83c604               | add                 esi, 4
            //   81fe00020000         | cmp                 esi, 0x200
            //   72dd                 | jb                  0xffffffdf
            //   b001                 | mov                 al, 1

        $sequence_6 = { 8b4028 03c1 51 ffd0 837e0800 7444 }
            // n = 6, score = 200
            //   8b4028               | mov                 eax, dword ptr [eax + 0x28]
            //   03c1                 | add                 eax, ecx
            //   51                   | push                ecx
            //   ffd0                 | call                eax
            //   837e0800             | cmp                 dword ptr [esi + 8], 0
            //   7444                 | je                  0x46

        $sequence_7 = { 5d c3 ff7728 8b4724 56 ffd0 }
            // n = 6, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   ff7728               | push                dword ptr [edi + 0x28]
            //   8b4724               | mov                 eax, dword ptr [edi + 0x24]
            //   56                   | push                esi
            //   ffd0                 | call                eax

        $sequence_8 = { 83c102 03c1 50 8b4720 }
            // n = 4, score = 200
            //   83c102               | add                 ecx, 2
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]

        $sequence_9 = { 33c9 8bc1 3914c598294100 7408 }
            // n = 4, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   8bc1                 | mov                 eax, ecx
            //   3914c598294100       | cmp                 dword ptr [eax*8 + 0x412998], edx
            //   7408                 | je                  0xa

    condition:
        7 of them and filesize < 204800
}