rule win_avaddon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.avaddon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avaddon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 56 ff15???????? 85c0 7527 ff15???????? 3d16000980 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7527                 | jne                 0x29
            //   ff15????????         |                     
            //   3d16000980           | cmp                 eax, 0x80090016

        $sequence_1 = { f20f100d???????? 0fb6c0 f20f5cca 660f6ec0 f30fe6c0 0fb6c2 f20f59c8 }
            // n = 7, score = 200
            //   f20f100d????????     |                     
            //   0fb6c0               | movzx               eax, al
            //   f20f5cca             | subsd               xmm1, xmm2
            //   660f6ec0             | movd                xmm0, eax
            //   f30fe6c0             | cvtdq2pd            xmm0, xmm0
            //   0fb6c2               | movzx               eax, dl
            //   f20f59c8             | mulsd               xmm1, xmm0

        $sequence_2 = { ff75d4 ffd6 c745fcffffffff 8b75ac 8945b4 85f6 }
            // n = 6, score = 200
            //   ff75d4               | push                dword ptr [ebp - 0x2c]
            //   ffd6                 | call                esi
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8b75ac               | mov                 esi, dword ptr [ebp - 0x54]
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   85f6                 | test                esi, esi

        $sequence_3 = { 8b5db8 037014 0375cc 8b4308 0faf45f0 03c2 }
            // n = 6, score = 200
            //   8b5db8               | mov                 ebx, dword ptr [ebp - 0x48]
            //   037014               | add                 esi, dword ptr [eax + 0x14]
            //   0375cc               | add                 esi, dword ptr [ebp - 0x34]
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   0faf45f0             | imul                eax, dword ptr [ebp - 0x10]
            //   03c2                 | add                 eax, edx

        $sequence_4 = { 83781408 8b7810 7202 8b08 ff75a8 8bd7 6a01 }
            // n = 7, score = 200
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   8b7810               | mov                 edi, dword ptr [eax + 0x10]
            //   7202                 | jb                  4
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff75a8               | push                dword ptr [ebp - 0x58]
            //   8bd7                 | mov                 edx, edi
            //   6a01                 | push                1

        $sequence_5 = { 3dffffff7f 7743 03c0 56 50 e8???????? 8bf0 }
            // n = 7, score = 200
            //   3dffffff7f           | cmp                 eax, 0x7fffffff
            //   7743                 | ja                  0x45
            //   03c0                 | add                 eax, eax
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { 84c9 754e 8b4e14 03c7 3bc1 7239 8b06 }
            // n = 7, score = 200
            //   84c9                 | test                cl, cl
            //   754e                 | jne                 0x50
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   03c7                 | add                 eax, edi
            //   3bc1                 | cmp                 eax, ecx
            //   7239                 | jb                  0x3b
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_7 = { 0faf5708 8b4f14 0faf5704 0faf17 03d1 3bca 734c }
            // n = 7, score = 200
            //   0faf5708             | imul                edx, dword ptr [edi + 8]
            //   8b4f14               | mov                 ecx, dword ptr [edi + 0x14]
            //   0faf5704             | imul                edx, dword ptr [edi + 4]
            //   0faf17               | imul                edx, dword ptr [edi]
            //   03d1                 | add                 edx, ecx
            //   3bca                 | cmp                 ecx, edx
            //   734c                 | jae                 0x4e

        $sequence_8 = { 8b85fcfeffff 83c204 40 3b8570ffffff 8985fcfeffff 8b85d8feffff 0f8ce9feffff }
            // n = 7, score = 200
            //   8b85fcfeffff         | mov                 eax, dword ptr [ebp - 0x104]
            //   83c204               | add                 edx, 4
            //   40                   | inc                 eax
            //   3b8570ffffff         | cmp                 eax, dword ptr [ebp - 0x90]
            //   8985fcfeffff         | mov                 dword ptr [ebp - 0x104], eax
            //   8b85d8feffff         | mov                 eax, dword ptr [ebp - 0x128]
            //   0f8ce9feffff         | jl                  0xfffffeef

        $sequence_9 = { ff10 8b45e4 83f808 7213 8d044502000000 50 ff75d0 }
            // n = 7, score = 200
            //   ff10                 | call                dword ptr [eax]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   83f808               | cmp                 eax, 8
            //   7213                 | jb                  0x15
            //   8d044502000000       | lea                 eax, [eax*2 + 2]
            //   50                   | push                eax
            //   ff75d0               | push                dword ptr [ebp - 0x30]

    condition:
        7 of them and filesize < 2343936
}