rule win_avos_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.avos_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avos_locker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85a8f9ffff 50 8d85fcf5ffff 50 8d8514f6ffff 50 83ec18 }
            // n = 7, score = 100
            //   8d85a8f9ffff         | lea                 eax, [ebp - 0x658]
            //   50                   | push                eax
            //   8d85fcf5ffff         | lea                 eax, [ebp - 0xa04]
            //   50                   | push                eax
            //   8d8514f6ffff         | lea                 eax, [ebp - 0x9ec]
            //   50                   | push                eax
            //   83ec18               | sub                 esp, 0x18

        $sequence_1 = { 57 8b4d18 85c9 743f 8b4514 3bd9 8b7c2424 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   85c9                 | test                ecx, ecx
            //   743f                 | je                  0x41
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   3bd9                 | cmp                 ebx, ecx
            //   8b7c2424             | mov                 edi, dword ptr [esp + 0x24]

        $sequence_2 = { 8d4dc0 e8???????? 8b4df4 64890d00000000 59 5e 8be5 }
            // n = 7, score = 100
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_3 = { e8???????? 3b750c 0f8469020000 8b8d54ffffff e9???????? 47 3b7d94 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   3b750c               | cmp                 esi, dword ptr [ebp + 0xc]
            //   0f8469020000         | je                  0x26f
            //   8b8d54ffffff         | mov                 ecx, dword ptr [ebp - 0xac]
            //   e9????????           |                     
            //   47                   | inc                 edi
            //   3b7d94               | cmp                 edi, dword ptr [ebp - 0x6c]

        $sequence_4 = { 2bc6 c1f803 50 e8???????? 895df0 c645fc02 8b13 }
            // n = 7, score = 100
            //   2bc6                 | sub                 eax, esi
            //   c1f803               | sar                 eax, 3
            //   50                   | push                eax
            //   e8????????           |                     
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8b13                 | mov                 edx, dword ptr [ebx]

        $sequence_5 = { 2b4b4c 2b534c 3bd1 8b4c240c 5f 5e 0f9cc0 }
            // n = 7, score = 100
            //   2b4b4c               | sub                 ecx, dword ptr [ebx + 0x4c]
            //   2b534c               | sub                 edx, dword ptr [ebx + 0x4c]
            //   3bd1                 | cmp                 edx, ecx
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   0f9cc0               | setl                al

        $sequence_6 = { c70300000000 c7430400000000 c7430800000000 8b10 8b4804 8945e4 8955e8 }
            // n = 7, score = 100
            //   c70300000000         | mov                 dword ptr [ebx], 0
            //   c7430400000000       | mov                 dword ptr [ebx + 4], 0
            //   c7430800000000       | mov                 dword ptr [ebx + 8], 0
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx

        $sequence_7 = { b908000000 894e44 8b0e 8b7e08 3bcf 0f840d010000 80395c }
            // n = 7, score = 100
            //   b908000000           | mov                 ecx, 8
            //   894e44               | mov                 dword ptr [esi + 0x44], ecx
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]
            //   3bcf                 | cmp                 ecx, edi
            //   0f840d010000         | je                  0x113
            //   80395c               | cmp                 byte ptr [ecx], 0x5c

        $sequence_8 = { ff75e4 ff75e0 8b01 ff500c 8b55e4 8b75e0 2bd6 }
            // n = 7, score = 100
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff500c               | call                dword ptr [eax + 0xc]
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   8b75e0               | mov                 esi, dword ptr [ebp - 0x20]
            //   2bd6                 | sub                 edx, esi

        $sequence_9 = { 894e30 c645fc02 8d4dbc e8???????? c745fcffffffff 8bc6 8b4df4 }
            // n = 7, score = 100
            //   894e30               | mov                 dword ptr [esi + 0x30], ecx
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8bc6                 | mov                 eax, esi
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 1701888
}