rule win_ayegent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ayegent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ayegent"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894c2411 8dbc2431030000 894c2415 889c2430030000 884c2419 b981000000 }
            // n = 6, score = 100
            //   894c2411             | mov                 dword ptr [esp + 0x11], ecx
            //   8dbc2431030000       | lea                 edi, [esp + 0x331]
            //   894c2415             | mov                 dword ptr [esp + 0x15], ecx
            //   889c2430030000       | mov                 byte ptr [esp + 0x330], bl
            //   884c2419             | mov                 byte ptr [esp + 0x19], cl
            //   b981000000           | mov                 ecx, 0x81

        $sequence_1 = { 8d3449 2bd1 8d34b5c8764000 832600 83c60c 4a }
            // n = 6, score = 100
            //   8d3449               | lea                 esi, [ecx + ecx*2]
            //   2bd1                 | sub                 edx, ecx
            //   8d34b5c8764000       | lea                 esi, [esi*4 + 0x4076c8]
            //   832600               | and                 dword ptr [esi], 0
            //   83c60c               | add                 esi, 0xc
            //   4a                   | dec                 edx

        $sequence_2 = { e8???????? b940000000 33c0 8dbc2459040000 889c2458040000 f3ab }
            // n = 6, score = 100
            //   e8????????           |                     
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8dbc2459040000       | lea                 edi, [esp + 0x459]
            //   889c2458040000       | mov                 byte ptr [esp + 0x458], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_3 = { 8a842440020000 83c418 3ac3 751f 8b7c241c }
            // n = 5, score = 100
            //   8a842440020000       | mov                 al, byte ptr [esp + 0x240]
            //   83c418               | add                 esp, 0x18
            //   3ac3                 | cmp                 al, bl
            //   751f                 | jne                 0x21
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]

        $sequence_4 = { 66ab aa 8d442408 56 50 ff15???????? 8d4c2408 }
            // n = 7, score = 100
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d442408             | lea                 eax, [esp + 8]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d4c2408             | lea                 ecx, [esp + 8]

        $sequence_5 = { 3bf7 0f8e07ffffff 5f 5e }
            // n = 4, score = 100
            //   3bf7                 | cmp                 esi, edi
            //   0f8e07ffffff         | jle                 0xffffff0d
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 8d7c2421 885c2420 f3ab 66ab 8d4c2420 }
            // n = 5, score = 100
            //   8d7c2421             | lea                 edi, [esp + 0x21]
            //   885c2420             | mov                 byte ptr [esp + 0x20], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d4c2420             | lea                 ecx, [esp + 0x20]

        $sequence_7 = { 66894c2404 33c0 8d4c2400 89442407 68???????? 51 }
            // n = 6, score = 100
            //   66894c2404           | mov                 word ptr [esp + 4], cx
            //   33c0                 | xor                 eax, eax
            //   8d4c2400             | lea                 ecx, [esp]
            //   89442407             | mov                 dword ptr [esp + 7], eax
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_8 = { 56 e8???????? 85c0 7438 8bbc243c010000 8b1d???????? 8d4c2434 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7438                 | je                  0x3a
            //   8bbc243c010000       | mov                 edi, dword ptr [esp + 0x13c]
            //   8b1d????????         |                     
            //   8d4c2434             | lea                 ecx, [esp + 0x34]

        $sequence_9 = { 57 8b3d???????? 56 ffd7 83f807 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   83f807               | cmp                 eax, 7

    condition:
        7 of them and filesize < 90112
}