rule win_babylon_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.babylon_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.babylon_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894b34 8b4610 8b4dc8 8b44010c 894318 8b45fc 668b00 }
            // n = 7, score = 100
            //   894b34               | mov                 dword ptr [ebx + 0x34], ecx
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   8b4dc8               | mov                 ecx, dword ptr [ebp - 0x38]
            //   8b44010c             | mov                 eax, dword ptr [ecx + eax + 0xc]
            //   894318               | mov                 dword ptr [ebx + 0x18], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   668b00               | mov                 ax, word ptr [eax]

        $sequence_1 = { ff7514 6a00 ff7510 ff750c 6a18 57 e8???????? }
            // n = 7, score = 100
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   6a00                 | push                0
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   6a18                 | push                0x18
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_2 = { f6401620 7407 b806010000 5d c3 8b4848 53 }
            // n = 7, score = 100
            //   f6401620             | test                byte ptr [eax + 0x16], 0x20
            //   7407                 | je                  9
            //   b806010000           | mov                 eax, 0x106
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4848               | mov                 ecx, dword ptr [eax + 0x48]
            //   53                   | push                ebx

        $sequence_3 = { ffb510ffffff 52 56 e8???????? 83c40c 89852cffffff 85c0 }
            // n = 7, score = 100
            //   ffb510ffffff         | push                dword ptr [ebp - 0xf0]
            //   52                   | push                edx
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   89852cffffff         | mov                 dword ptr [ebp - 0xd4], eax
            //   85c0                 | test                eax, eax

        $sequence_4 = { e8???????? 59 8945fc bf???????? 8b1f 50 53 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   bf????????           |                     
            //   8b1f                 | mov                 ebx, dword ptr [edi]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_5 = { 8bc6 8b7510 eb03 8b4510 50 57 e8???????? }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   eb03                 | jmp                 5
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_6 = { ff7518 ff75a8 ff75e4 ff75e0 ff75ac ff75f4 ffb57cffffff }
            // n = 7, score = 100
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   ff75a8               | push                dword ptr [ebp - 0x58]
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ff75ac               | push                dword ptr [ebp - 0x54]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ffb57cffffff         | push                dword ptr [ebp - 0x84]

        $sequence_7 = { ff7240 8b4004 ff75ec 8b00 894508 0fb74020 8945f4 }
            // n = 7, score = 100
            //   ff7240               | push                dword ptr [edx + 0x40]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   0fb74020             | movzx               eax, word ptr [eax + 0x20]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_8 = { 8b45f8 0fb7f1 8b4df4 53 8364020100 c644020700 8b4124 }
            // n = 7, score = 100
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   0fb7f1               | movzx               esi, cx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   53                   | push                ebx
            //   8364020100           | and                 dword ptr [edx + eax + 1], 0
            //   c644020700           | mov                 byte ptr [edx + eax + 7], 0
            //   8b4124               | mov                 eax, dword ptr [ecx + 0x24]

        $sequence_9 = { eb75 0fbf4320 3bc8 7514 8b45b8 6a00 03c1 }
            // n = 7, score = 100
            //   eb75                 | jmp                 0x77
            //   0fbf4320             | movsx               eax, word ptr [ebx + 0x20]
            //   3bc8                 | cmp                 ecx, eax
            //   7514                 | jne                 0x16
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   6a00                 | push                0
            //   03c1                 | add                 eax, ecx

    condition:
        7 of them and filesize < 1604608
}