rule win_badnews_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.badnews."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badnews"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 83c404 68???????? 6804010000 ff15???????? }
            // n = 6, score = 1000
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   68????????           |                     
            //   6804010000           | push                0x104
            //   ff15????????         |                     

        $sequence_1 = { 83e957 eb02 33c9 c0e004 02c1 3423 c0c003 }
            // n = 7, score = 900
            //   83e957               | sub                 ecx, 0x57
            //   eb02                 | jmp                 4
            //   33c9                 | xor                 ecx, ecx
            //   c0e004               | shl                 al, 4
            //   02c1                 | add                 al, cl
            //   3423                 | xor                 al, 0x23
            //   c0c003               | rol                 al, 3

        $sequence_2 = { c78534ffffff47657457 c78538ffffff696e646f c7853cffffff77546578 66c78540ffffff7457 }
            // n = 4, score = 900
            //   c78534ffffff47657457     | mov    dword ptr [ebp - 0xcc], 0x57746547
            //   c78538ffffff696e646f     | mov    dword ptr [ebp - 0xc8], 0x6f646e69
            //   c7853cffffff77546578     | mov    dword ptr [ebp - 0xc4], 0x78655477
            //   66c78540ffffff7457     | mov    word ptr [ebp - 0xc0], 0x5774

        $sequence_3 = { c705????????55736572 c705????????33322e64 66c705????????6c6c c605????????00 }
            // n = 4, score = 900
            //   c705????????55736572     |     
            //   c705????????33322e64     |     
            //   66c705????????6c6c     |     
            //   c605????????00       |                     

        $sequence_4 = { 55 8bec 8b450c 3d01020000 }
            // n = 4, score = 900
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   3d01020000           | cmp                 eax, 0x201

        $sequence_5 = { 33c5 8945fc 53 56 57 8d8534ffffff }
            // n = 6, score = 900
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]

        $sequence_6 = { 68???????? 6a1a 68???????? 57 }
            // n = 4, score = 800
            //   68????????           |                     
            //   6a1a                 | push                0x1a
            //   68????????           |                     
            //   57                   | push                edi

        $sequence_7 = { 6a00 d1f9 68???????? 03c9 }
            // n = 4, score = 800
            //   6a00                 | push                0
            //   d1f9                 | sar                 ecx, 1
            //   68????????           |                     
            //   03c9                 | add                 ecx, ecx

        $sequence_8 = { 56 ffd3 85c0 7403 83c608 }
            // n = 5, score = 700
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   83c608               | add                 esi, 8

        $sequence_9 = { 57 6a00 6880000000 6a04 6a00 6a01 6a04 }
            // n = 7, score = 700
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a04                 | push                4
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a04                 | push                4

        $sequence_10 = { 8bf0 56 ff15???????? 50 6a40 }
            // n = 5, score = 700
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   50                   | push                eax
            //   6a40                 | push                0x40

        $sequence_11 = { ff15???????? 85c0 7405 83c004 eb02 }
            // n = 5, score = 700
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   83c004               | add                 eax, 4
            //   eb02                 | jmp                 4

        $sequence_12 = { ff15???????? b8???????? 83c424 8d5002 668b08 83c002 }
            // n = 6, score = 500
            //   ff15????????         |                     
            //   b8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   8d5002               | lea                 edx, [eax + 2]
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2

        $sequence_13 = { c745e4f0b10110 a1???????? eb1a c745e4ecb10110 a1???????? }
            // n = 5, score = 100
            //   c745e4f0b10110       | mov                 dword ptr [ebp - 0x1c], 0x1001b1f0
            //   a1????????           |                     
            //   eb1a                 | jmp                 0x1c
            //   c745e4ecb10110       | mov                 dword ptr [ebp - 0x1c], 0x1001b1ec
            //   a1????????           |                     

        $sequence_14 = { 8b0485d0a70110 f644010480 0f8432030000 e8???????? 33c9 8b406c 3988a8000000 }
            // n = 7, score = 100
            //   8b0485d0a70110       | mov                 eax, dword ptr [eax*4 + 0x1001a7d0]
            //   f644010480           | test                byte ptr [ecx + eax + 4], 0x80
            //   0f8432030000         | je                  0x338
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   8b406c               | mov                 eax, dword ptr [eax + 0x6c]
            //   3988a8000000         | cmp                 dword ptr [eax + 0xa8], ecx

        $sequence_15 = { c1e306 894df4 895ddc 8b148dd0a70110 8a441a04 a801 0f84fe060000 }
            // n = 7, score = 100
            //   c1e306               | shl                 ebx, 6
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx
            //   8b148dd0a70110       | mov                 edx, dword ptr [ecx*4 + 0x1001a7d0]
            //   8a441a04             | mov                 al, byte ptr [edx + ebx + 4]
            //   a801                 | test                al, 1
            //   0f84fe060000         | je                  0x704

        $sequence_16 = { 6a53 8885d4fdffff 8d85d5fdffff 6a00 }
            // n = 4, score = 100
            //   6a53                 | push                0x53
            //   8885d4fdffff         | mov                 byte ptr [ebp - 0x22c], al
            //   8d85d5fdffff         | lea                 eax, [ebp - 0x22b]
            //   6a00                 | push                0

        $sequence_17 = { 898518e5ffff 8b8528e5ffff 8b0485d0a70110 89853ce5ffff 397c0138 }
            // n = 5, score = 100
            //   898518e5ffff         | mov                 dword ptr [ebp - 0x1ae8], eax
            //   8b8528e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad8]
            //   8b0485d0a70110       | mov                 eax, dword ptr [eax*4 + 0x1001a7d0]
            //   89853ce5ffff         | mov                 dword ptr [ebp - 0x1ac4], eax
            //   397c0138             | cmp                 dword ptr [ecx + eax + 0x38], edi

        $sequence_18 = { 3bd1 72e4 660f6f05???????? 68???????? f30f7f8558fbffff e8???????? }
            // n = 6, score = 100
            //   3bd1                 | cmp                 edx, ecx
            //   72e4                 | jb                  0xffffffe6
            //   660f6f05????????     |                     
            //   68????????           |                     
            //   f30f7f8558fbffff     | movdqu              xmmword ptr [ebp - 0x4a8], xmm0
            //   e8????????           |                     

        $sequence_19 = { f3a4 8d8d2cfdffff 49 8d4900 }
            // n = 4, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d8d2cfdffff         | lea                 ecx, [ebp - 0x2d4]
            //   49                   | dec                 ecx
            //   8d4900               | lea                 ecx, [ecx]

        $sequence_20 = { 84c0 75f7 8da42400000000 ffb554fbffff }
            // n = 4, score = 100
            //   84c0                 | test                al, al
            //   75f7                 | jne                 0xfffffff9
            //   8da42400000000       | lea                 esp, [esp]
            //   ffb554fbffff         | push                dword ptr [ebp - 0x4ac]

    condition:
        7 of them and filesize < 612352
}