rule win_bernhardpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bernhardpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bernhardpos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1e806 83e03f 8b4d0c 034df4 8a9020544100 }
            // n = 5, score = 200
            //   c1e806               | shr                 eax, 6
            //   83e03f               | and                 eax, 0x3f
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   034df4               | add                 ecx, dword ptr [ebp - 0xc]
            //   8a9020544100         | mov                 dl, byte ptr [eax + 0x415420]

        $sequence_1 = { 6815b43ed8 a1???????? 50 e8???????? }
            // n = 4, score = 200
            //   6815b43ed8           | push                0xd83eb415
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 0fbe5415f8 33ca 8b4508 0345f4 8808 ebc7 5f }
            // n = 7, score = 200
            //   0fbe5415f8           | movsx               edx, byte ptr [ebp + edx - 8]
            //   33ca                 | xor                 ecx, edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345f4               | add                 eax, dword ptr [ebp - 0xc]
            //   8808                 | mov                 byte ptr [eax], cl
            //   ebc7                 | jmp                 0xffffffc9
            //   5f                   | pop                 edi

        $sequence_3 = { c745f800000000 c745f400000000 8b45f8 3b45fc 0f831d010000 8b45f8 }
            // n = 6, score = 200
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]
            //   0f831d010000         | jae                 0x123
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_4 = { ba04000000 c1e200 8b8415d4fdffff 50 }
            // n = 4, score = 200
            //   ba04000000           | mov                 edx, 4
            //   c1e200               | shl                 edx, 0
            //   8b8415d4fdffff       | mov                 eax, dword ptr [ebp + edx - 0x22c]
            //   50                   | push                eax

        $sequence_5 = { 8bec 83ec48 53 56 57 c745fc00000000 c745f800000000 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   83ec48               | sub                 esp, 0x48
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0

        $sequence_6 = { 83e863 5f 5e 5b }
            // n = 4, score = 200
            //   83e863               | sub                 eax, 0x63
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_7 = { 8d85d0feffff 8985c8feffff 8d85c4feffff 50 6aff 68ff000000 }
            // n = 6, score = 200
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   8985c8feffff         | mov                 dword ptr [ebp - 0x138], eax
            //   8d85c4feffff         | lea                 eax, [ebp - 0x13c]
            //   50                   | push                eax
            //   6aff                 | push                -1
            //   68ff000000           | push                0xff

        $sequence_8 = { e8???????? a3???????? 68a86b4aa0 a1???????? 50 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   a3????????           |                     
            //   68a86b4aa0           | push                0xa04a6ba8
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { e8???????? 83c404 6a01 8d85d0feffff 50 ff15???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6a01                 | push                1
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 368640
}