rule win_blackbasta_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.blackbasta."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackbasta"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b3403 85f6 0f856f010000 eb02 33f6 80791400 7410 }
            // n = 7, score = 100
            //   8b3403               | mov                 esi, dword ptr [ebx + eax]
            //   85f6                 | test                esi, esi
            //   0f856f010000         | jne                 0x175
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   80791400             | cmp                 byte ptr [ecx + 0x14], 0
            //   7410                 | je                  0x12

        $sequence_1 = { e9???????? c7456001000000 83fe01 0f86ff000000 90 8d4548 50 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c7456001000000       | mov                 dword ptr [ebp + 0x60], 1
            //   83fe01               | cmp                 esi, 1
            //   0f86ff000000         | jbe                 0x105
            //   90                   | nop                 
            //   8d4548               | lea                 eax, [ebp + 0x48]
            //   50                   | push                eax

        $sequence_2 = { 8b450c 83c01c 50 8d4920 e8???????? 8b450c 8b4df0 }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   83c01c               | add                 eax, 0x1c
            //   50                   | push                eax
            //   8d4920               | lea                 ecx, [ecx + 0x20]
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_3 = { 56 8d581c 8d6804 7442 6a00 8bcb }
            // n = 6, score = 100
            //   56                   | push                esi
            //   8d581c               | lea                 ebx, [eax + 0x1c]
            //   8d6804               | lea                 ebp, [eax + 4]
            //   7442                 | je                  0x44
            //   6a00                 | push                0
            //   8bcb                 | mov                 ecx, ebx

        $sequence_4 = { 53 56 57 8bf9 8b37 85f6 747a }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   85f6                 | test                esi, esi
            //   747a                 | je                  0x7c

        $sequence_5 = { 56 51 6a01 8bcb ff5034 8b03 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   51                   | push                ecx
            //   6a01                 | push                1
            //   8bcb                 | mov                 ecx, ebx
            //   ff5034               | call                dword ptr [eax + 0x34]
            //   8b03                 | mov                 eax, dword ptr [ebx]

        $sequence_6 = { c7471400000000 e8???????? c7461000000000 83c40c c746140f000000 c60600 be08000000 }
            // n = 7, score = 100
            //   c7471400000000       | mov                 dword ptr [edi + 0x14], 0
            //   e8????????           |                     
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   83c40c               | add                 esp, 0xc
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c60600               | mov                 byte ptr [esi], 0
            //   be08000000           | mov                 esi, 8

        $sequence_7 = { 8d957cffffff 52 8d95d4feffff 52 ff5024 8b8dd0feffff 8d957cffffff }
            // n = 7, score = 100
            //   8d957cffffff         | lea                 edx, [ebp - 0x84]
            //   52                   | push                edx
            //   8d95d4feffff         | lea                 edx, [ebp - 0x12c]
            //   52                   | push                edx
            //   ff5024               | call                dword ptr [eax + 0x24]
            //   8b8dd0feffff         | mov                 ecx, dword ptr [ebp - 0x130]
            //   8d957cffffff         | lea                 edx, [ebp - 0x84]

        $sequence_8 = { c7855cfeffff980a0a10 e8???????? 57 8d8d78feffff c745fc09000000 }
            // n = 5, score = 100
            //   c7855cfeffff980a0a10     | mov    dword ptr [ebp - 0x1a4], 0x100a0a98
            //   e8????????           |                     
            //   57                   | push                edi
            //   8d8d78feffff         | lea                 ecx, [ebp - 0x188]
            //   c745fc09000000       | mov                 dword ptr [ebp - 4], 9

        $sequence_9 = { 8975f0 c706???????? c74604???????? c74608???????? c7462060ed0910 c745fcffffffff e8???????? }
            // n = 7, score = 100
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   c706????????         |                     
            //   c74604????????       |                     
            //   c74608????????       |                     
            //   c7462060ed0910       | mov                 dword ptr [esi + 0x20], 0x1009ed60
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1758208
}