rule win_bravonc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bravonc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bravonc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? 6a06 68???????? 50 ffd6 83c40c 85c0 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   6a06                 | push                6
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_1 = { 034a24 034dfc 8d8401d6c162ca 8945fc }
            // n = 4, score = 100
            //   034a24               | add                 ecx, dword ptr [edx + 0x24]
            //   034dfc               | add                 ecx, dword ptr [ebp - 4]
            //   8d8401d6c162ca       | lea                 eax, [ecx + eax - 0x359d3e2a]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_2 = { 56 8d85fcfeffff 56 50 ff750c 56 e8???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_3 = { 8d45c8 68???????? 50 8d85e4feffff 50 e8???????? 83c40c }
            // n = 7, score = 100
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   68????????           |                     
            //   50                   | push                eax
            //   8d85e4feffff         | lea                 eax, [ebp - 0x11c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_4 = { 59 33c0 8d7db0 895dac c645fc01 895df0 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   8d7db0               | lea                 edi, [ebp - 0x50]
            //   895dac               | mov                 dword ptr [ebp - 0x54], ebx
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx

        $sequence_5 = { 8bf1 57 8b7d0c 8b460c 8d0c38 3b4e08 }
            // n = 6, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   8d0c38               | lea                 ecx, [eax + edi]
            //   3b4e08               | cmp                 ecx, dword ptr [esi + 8]

        $sequence_6 = { 66897004 5f 5e 668908 66895006 5b c9 }
            // n = 7, score = 100
            //   66897004             | mov                 word ptr [eax + 4], si
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   668908               | mov                 word ptr [eax], cx
            //   66895006             | mov                 word ptr [eax + 6], dx
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_7 = { ff15???????? 59 3bc3 59 7404 802000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx
            //   59                   | pop                 ecx
            //   7404                 | je                  6
            //   802000               | and                 byte ptr [eax], 0

        $sequence_8 = { 51 b85c120000 e8???????? 53 56 57 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   b85c120000           | mov                 eax, 0x125c
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_9 = { 59 8d7db0 6a10 c745ac44000000 59 895df0 f3ab }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   8d7db0               | lea                 edi, [ebp - 0x50]
            //   6a10                 | push                0x10
            //   c745ac44000000       | mov                 dword ptr [ebp - 0x54], 0x44
            //   59                   | pop                 ecx
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 131072
}