rule win_brbbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.brbbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.brbbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f88f0000000 488d0d421d0100 e8???????? 8bd8 85c0 0f88da000000 }
            // n = 7, score = 100
            //   85c0                 | dec                 eax
            //   0f88f0000000         | mov                 ecx, ebx
            //   488d0d421d0100       | dec                 eax
            //   e8????????           |                     
            //   8bd8                 | add                 esi, 8
            //   85c0                 | cmovl               ebx, dword ptr [eax]
            //   0f88da000000         | cmp                 ecx, ebx

        $sequence_1 = { 418bd4 488bce 4c89742460 e8???????? 4c8b7540 8bd8 }
            // n = 6, score = 100
            //   418bd4               | dec                 eax
            //   488bce               | lea                 ecx, [esp + 0x20]
            //   4c89742460           | dec                 eax
            //   e8????????           |                     
            //   4c8b7540             | lea                 ecx, [esp + 0x20]
            //   8bd8                 | dec                 eax

        $sequence_2 = { 488bf8 0f85d5000000 488d0d07460000 ff15???????? 488bf0 4885c0 }
            // n = 6, score = 100
            //   488bf8               | dec                 ebx
            //   0f85d5000000         | mov                 eax, dword ptr [eax + edi*8 + 0x15ac0]
            //   488d0d07460000       | mov                 byte ptr [eax + esi + 0x3a], dl
            //   ff15????????         |                     
            //   488bf0               | jmp                 0x9d
            //   4885c0               | dec                 ecx

        $sequence_3 = { 7528 48833d????????00 741e 488d0d7dde0000 e8???????? 85c0 740e }
            // n = 7, score = 100
            //   7528                 | jne                 0x239
            //   48833d????????00     |                     
            //   741e                 | mov                 ebx, eax
            //   488d0d7dde0000       | dec                 esp
            //   e8????????           |                     
            //   85c0                 | mov                 ebp, eax
            //   740e                 | dec                 eax

        $sequence_4 = { 4c895c3040 4b8b84f9c05a0100 498bd6 41b80a000000 }
            // n = 4, score = 100
            //   4c895c3040           | mov                 dword ptr [ebp], eax
            //   4b8b84f9c05a0100     | dec                 eax
            //   498bd6               | or                  ecx, 0xffffffff
            //   41b80a000000         | dec                 eax

        $sequence_5 = { 752e 4b8b84f9c05a0100 8a4c303a 413ac8 741d 85db }
            // n = 6, score = 100
            //   752e                 | mov                 ebp, edi
            //   4b8b84f9c05a0100     | dec                 ecx
            //   8a4c303a             | sar                 ebp, 5
            //   413ac8               | dec                 esp
            //   741d                 | lea                 esi, [0xc48c]
            //   85db                 | jae                 0x8c1

        $sequence_6 = { 33d2 41b803010000 c68424f001000000 e8???????? 488d8c24e1000000 33d2 }
            // n = 6, score = 100
            //   33d2                 | dec                 eax
            //   41b803010000         | lea                 ecx, [0x11cbb]
            //   c68424f001000000     | dec                 eax
            //   e8????????           |                     
            //   488d8c24e1000000     | test                ebx, ebx
            //   33d2                 | je                  0x1d8

        $sequence_7 = { 488bce ff15???????? 85c0 747f 035c2420 }
            // n = 5, score = 100
            //   488bce               | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, eax
            //   747f                 | dec                 esp
            //   035c2420             | lea                 eax, [edi + 4]

        $sequence_8 = { 53 4883ec70 33db 48897010 }
            // n = 4, score = 100
            //   53                   | dec                 eax
            //   4883ec70             | dec                 ecx
            //   33db                 | add                 edx, ecx
            //   48897010             | dec                 eax

        $sequence_9 = { 33d2 897c2420 488be8 488906 ff15???????? 85c0 7506 }
            // n = 7, score = 100
            //   33d2                 | mov                 ecx, dword ptr [ebx]
            //   897c2420             | dec                 eax
            //   488be8               | mov                 dword ptr [ebx], eax
            //   488906               | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | add                 ebx, 8
            //   7506                 | dec                 eax

    condition:
        7 of them and filesize < 198656
}