rule win_breach_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.breach_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.breach_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7840548ffffffe4024400 8b8548ffffff 8b4804 8d41a0 89840d44ffffff 8d8d4cffffff e8???????? }
            // n = 7, score = 200
            //   c7840548ffffffe4024400     | mov    dword ptr [ebp + eax - 0xb8], 0x4402e4
            //   8b8548ffffff         | mov                 eax, dword ptr [ebp - 0xb8]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8d41a0               | lea                 eax, [ecx - 0x60]
            //   89840d44ffffff       | mov                 dword ptr [ebp + ecx - 0xbc], eax
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]
            //   e8????????           |                     

        $sequence_1 = { 68???????? 8d855cfbffff c745fc65000000 50 8bce e8???????? }
            // n = 6, score = 200
            //   68????????           |                     
            //   8d855cfbffff         | lea                 eax, [ebp - 0x4a4]
            //   c745fc65000000       | mov                 dword ptr [ebp - 4], 0x65
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_2 = { e8???????? c1e008 8bce 03f8 e8???????? c1e010 8bce }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c1e008               | shl                 eax, 8
            //   8bce                 | mov                 ecx, esi
            //   03f8                 | add                 edi, eax
            //   e8????????           |                     
            //   c1e010               | shl                 eax, 0x10
            //   8bce                 | mov                 ecx, esi

        $sequence_3 = { 8b0e 894654 e8???????? 8b06 83781000 7514 33c0 }
            // n = 7, score = 200
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   894654               | mov                 dword ptr [esi + 0x54], eax
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83781000             | cmp                 dword ptr [eax + 0x10], 0
            //   7514                 | jne                 0x16
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 5d c3 837e1000 0f85f4feffff c74720ffffffff 33c0 }
            // n = 6, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   837e1000             | cmp                 dword ptr [esi + 0x10], 0
            //   0f85f4feffff         | jne                 0xfffffefa
            //   c74720ffffffff       | mov                 dword ptr [edi + 0x20], 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { c6459800 e8???????? 68???????? 6a01 8d4598 c745fc00000000 50 }
            // n = 7, score = 200
            //   c6459800             | mov                 byte ptr [ebp - 0x68], 0
            //   e8????????           |                     
            //   68????????           |                     
            //   6a01                 | push                1
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   50                   | push                eax

        $sequence_6 = { ff75ac e8???????? 83c404 8b7d80 8d856cffffff ffb57cffffff 8bb56cffffff }
            // n = 7, score = 200
            //   ff75ac               | push                dword ptr [ebp - 0x54]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b7d80               | mov                 edi, dword ptr [ebp - 0x80]
            //   8d856cffffff         | lea                 eax, [ebp - 0x94]
            //   ffb57cffffff         | push                dword ptr [ebp - 0x84]
            //   8bb56cffffff         | mov                 esi, dword ptr [ebp - 0x94]

        $sequence_7 = { c7465800000000 e8???????? 894654 c645fc04 c7465c00000000 c7466000000000 e8???????? }
            // n = 7, score = 200
            //   c7465800000000       | mov                 dword ptr [esi + 0x58], 0
            //   e8????????           |                     
            //   894654               | mov                 dword ptr [esi + 0x54], eax
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   c7465c00000000       | mov                 dword ptr [esi + 0x5c], 0
            //   c7466000000000       | mov                 dword ptr [esi + 0x60], 0
            //   e8????????           |                     

        $sequence_8 = { 66d3ef 8b4de4 83c1f0 6689b8b0160000 0188b4160000 eb19 668b90b40a0000 }
            // n = 7, score = 200
            //   66d3ef               | shr                 di, cl
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   83c1f0               | add                 ecx, -0x10
            //   6689b8b0160000       | mov                 word ptr [eax + 0x16b0], di
            //   0188b4160000         | add                 dword ptr [eax + 0x16b4], ecx
            //   eb19                 | jmp                 0x1b
            //   668b90b40a0000       | mov                 dx, word ptr [eax + 0xab4]

        $sequence_9 = { 7408 83c002 49 75f5 33c0 85c0 7453 }
            // n = 7, score = 200
            //   7408                 | je                  0xa
            //   83c002               | add                 eax, 2
            //   49                   | dec                 ecx
            //   75f5                 | jne                 0xfffffff7
            //   33c0                 | xor                 eax, eax
            //   85c0                 | test                eax, eax
            //   7453                 | je                  0x55

    condition:
        7 of them and filesize < 645120
}