rule win_breakthrough_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.breakthrough_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.breakthrough_loader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8038154500 8945e4 803800 8bc8 7435 }
            // n = 5, score = 100
            //   8d8038154500         | lea                 eax, [eax + 0x451538]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   803800               | cmp                 byte ptr [eax], 0
            //   8bc8                 | mov                 ecx, eax
            //   7435                 | je                  0x37

        $sequence_1 = { 83e13f c1f806 6bc930 8b048540354500 80640828fe ff33 }
            // n = 6, score = 100
            //   83e13f               | and                 ecx, 0x3f
            //   c1f806               | sar                 eax, 6
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b048540354500       | mov                 eax, dword ptr [eax*4 + 0x453540]
            //   80640828fe           | and                 byte ptr [eax + ecx + 0x28], 0xfe
            //   ff33                 | push                dword ptr [ebx]

        $sequence_2 = { 663b88b0924400 740d 83c002 83f814 72ef 33c0 40 }
            // n = 7, score = 100
            //   663b88b0924400       | cmp                 cx, word ptr [eax + 0x4492b0]
            //   740d                 | je                  0xf
            //   83c002               | add                 eax, 2
            //   83f814               | cmp                 eax, 0x14
            //   72ef                 | jb                  0xfffffff1
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_3 = { c745c007000000 8bf1 668945ac 8945d4 668945c4 8b450c 807e4800 }
            // n = 7, score = 100
            //   c745c007000000       | mov                 dword ptr [ebp - 0x40], 7
            //   8bf1                 | mov                 esi, ecx
            //   668945ac             | mov                 word ptr [ebp - 0x54], ax
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   668945c4             | mov                 word ptr [ebp - 0x3c], ax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   807e4800             | cmp                 byte ptr [esi + 0x48], 0

        $sequence_4 = { 57 e8???????? 83c414 8d4de4 837df810 8bf0 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   837df810             | cmp                 dword ptr [ebp - 8], 0x10
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { c745f800000000 c645e800 83f810 720d }
            // n = 4, score = 100
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c645e800             | mov                 byte ptr [ebp - 0x18], 0
            //   83f810               | cmp                 eax, 0x10
            //   720d                 | jb                  0xf

        $sequence_6 = { 59 83f80a 7336 8b4d88 83f924 7d0f 8a809c384400 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   83f80a               | cmp                 eax, 0xa
            //   7336                 | jae                 0x38
            //   8b4d88               | mov                 ecx, dword ptr [ebp - 0x78]
            //   83f924               | cmp                 ecx, 0x24
            //   7d0f                 | jge                 0x11
            //   8a809c384400         | mov                 al, byte ptr [eax + 0x44389c]

        $sequence_7 = { 8b049540354500 c644012801 8b049540354500 897c0118 8bfe e9???????? }
            // n = 6, score = 100
            //   8b049540354500       | mov                 eax, dword ptr [edx*4 + 0x453540]
            //   c644012801           | mov                 byte ptr [ecx + eax + 0x28], 1
            //   8b049540354500       | mov                 eax, dword ptr [edx*4 + 0x453540]
            //   897c0118             | mov                 dword ptr [ecx + eax + 0x18], edi
            //   8bfe                 | mov                 edi, esi
            //   e9????????           |                     

        $sequence_8 = { eb55 8b1c9dcc614400 56 6800080000 6a00 }
            // n = 5, score = 100
            //   eb55                 | jmp                 0x57
            //   8b1c9dcc614400       | mov                 ebx, dword ptr [ebx*4 + 0x4461cc]
            //   56                   | push                esi
            //   6800080000           | push                0x800
            //   6a00                 | push                0

        $sequence_9 = { 83e03f c1f906 6bf030 03348d40354500 837e18ff 740c 837e18fe }
            // n = 7, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bf030               | imul                esi, eax, 0x30
            //   03348d40354500       | add                 esi, dword ptr [ecx*4 + 0x453540]
            //   837e18ff             | cmp                 dword ptr [esi + 0x18], -1
            //   740c                 | je                  0xe
            //   837e18fe             | cmp                 dword ptr [esi + 0x18], -2

    condition:
        7 of them and filesize < 753664
}