rule win_bredolab_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bredolab."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bredolab"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 84c9 0f849f000000 83fe01 0f8426010000 }
            // n = 4, score = 200
            //   84c9                 | test                cl, cl
            //   0f849f000000         | je                  0xa5
            //   83fe01               | cmp                 esi, 1
            //   0f8426010000         | je                  0x12c

        $sequence_1 = { 891c24 e8???????? 89c6 ebbf 55 89e5 57 }
            // n = 7, score = 200
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   89c6                 | mov                 esi, eax
            //   ebbf                 | jmp                 0xffffffc1
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   57                   | push                edi

        $sequence_2 = { f3a4 c64415d800 8b550c 89542404 890424 }
            // n = 5, score = 200
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   c64415d800           | mov                 byte ptr [ebp + edx - 0x28], 0
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_3 = { e9???????? 89f3 c7864c09000000000000 40 7496 }
            // n = 5, score = 200
            //   e9????????           |                     
            //   89f3                 | mov                 ebx, esi
            //   c7864c09000000000000     | mov    dword ptr [esi + 0x94c], 0
            //   40                   | inc                 eax
            //   7496                 | je                  0xffffff98

        $sequence_4 = { ff15???????? 57 57 8b45e4 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   57                   | push                edi
            //   57                   | push                edi
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_5 = { 8a4d10 d3e3 899d60ffffff 8b4510 8a4d0c d3e0 03450c }
            // n = 7, score = 200
            //   8a4d10               | mov                 cl, byte ptr [ebp + 0x10]
            //   d3e3                 | shl                 ebx, cl
            //   899d60ffffff         | mov                 dword ptr [ebp - 0xa0], ebx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8a4d0c               | mov                 cl, byte ptr [ebp + 0xc]
            //   d3e0                 | shl                 eax, cl
            //   03450c               | add                 eax, dword ptr [ebp + 0xc]

        $sequence_6 = { 0f84f0feffff c744240802000000 8b8d70ffffff 894c2404 8b9574ffffff }
            // n = 5, score = 200
            //   0f84f0feffff         | je                  0xfffffef6
            //   c744240802000000     | mov                 dword ptr [esp + 8], 2
            //   8b8d70ffffff         | mov                 ecx, dword ptr [ebp - 0x90]
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   8b9574ffffff         | mov                 edx, dword ptr [ebp - 0x8c]

        $sequence_7 = { 8b5514 891424 ff15???????? 83ec1c 89c2 83f8ff }
            // n = 6, score = 200
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   891424               | mov                 dword ptr [esp], edx
            //   ff15????????         |                     
            //   83ec1c               | sub                 esp, 0x1c
            //   89c2                 | mov                 edx, eax
            //   83f8ff               | cmp                 eax, -1

        $sequence_8 = { e8???????? 84c0 7409 8b45f4 83c434 5b }
            // n = 6, score = 200
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7409                 | je                  0xb
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c434               | add                 esp, 0x34
            //   5b                   | pop                 ebx

        $sequence_9 = { 85c0 0f88ad000000 c7442410e0710010 c744240c40640010 c744240804000000 }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   0f88ad000000         | js                  0xb3
            //   c7442410e0710010     | mov                 dword ptr [esp + 0x10], 0x100071e0
            //   c744240c40640010     | mov                 dword ptr [esp + 0xc], 0x10006440
            //   c744240804000000     | mov                 dword ptr [esp + 8], 4

    condition:
        7 of them and filesize < 90112
}