rule win_bunitu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bunitu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bunitu"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8c29d4feffff 0fb709 8bf9 59 8d8dd9feffff c6040800 3680bc28d8feffff2f }
            // n = 7, score = 1300
            //   8d8c29d4feffff       | lea                 ecx, [ecx + ebp - 0x12c]
            //   0fb709               | movzx               ecx, word ptr [ecx]
            //   8bf9                 | mov                 edi, ecx
            //   59                   | pop                 ecx
            //   8d8dd9feffff         | lea                 ecx, [ebp - 0x127]
            //   c6040800             | mov                 byte ptr [eax + ecx], 0
            //   3680bc28d8feffff2f     | cmp    byte ptr ss:[eax + ebp - 0x128], 0x2f

        $sequence_1 = { 6a00 50 ff15???????? 6a00 68e8030000 ff15???????? 33c0 }
            // n = 7, score = 1300
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 8b4508 8b08 894df8 8b4804 894dfc c7400400000000 c70000000000 }
            // n = 7, score = 1300
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   c7400400000000       | mov                 dword ptr [eax + 4], 0
            //   c70000000000         | mov                 dword ptr [eax], 0

        $sequence_3 = { 7412 48 50 ff7508 ffb528fdffff e8???????? }
            // n = 6, score = 1300
            //   7412                 | je                  0x14
            //   48                   | dec                 eax
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffb528fdffff         | push                dword ptr [ebp - 0x2d8]
            //   e8????????           |                     

        $sequence_4 = { e8???????? 8945fc c78560feffff00000000 0f31 }
            // n = 4, score = 1300
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c78560feffff00000000     | mov    dword ptr [ebp - 0x1a0], 0
            //   0f31                 | rdtsc               

        $sequence_5 = { 50 ff75ec e8???????? 0bc0 7e18 50 }
            // n = 6, score = 1300
            //   50                   | push                eax
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax
            //   7e18                 | jle                 0x1a
            //   50                   | push                eax

        $sequence_6 = { c70003000000 ffb524fdffff 8f4004 ffb528fdffff }
            // n = 4, score = 1300
            //   c70003000000         | mov                 dword ptr [eax], 3
            //   ffb524fdffff         | push                dword ptr [ebp - 0x2dc]
            //   8f4004               | pop                 dword ptr [eax + 4]
            //   ffb528fdffff         | push                dword ptr [ebp - 0x2d8]

        $sequence_7 = { ffb524fdffff e8???????? eb12 6a08 68???????? ffb524fdffff e8???????? }
            // n = 7, score = 1300
            //   ffb524fdffff         | push                dword ptr [ebp - 0x2dc]
            //   e8????????           |                     
            //   eb12                 | jmp                 0x14
            //   6a08                 | push                8
            //   68????????           |                     
            //   ffb524fdffff         | push                dword ptr [ebp - 0x2dc]
            //   e8????????           |                     

        $sequence_8 = { 81c458feffff 8dbd58feffff b91c000000 33c0 f3aa e8???????? }
            // n = 6, score = 1300
            //   81c458feffff         | add                 esp, 0xfffffe58
            //   8dbd58feffff         | lea                 edi, [ebp - 0x1a8]
            //   b91c000000           | mov                 ecx, 0x1c
            //   33c0                 | xor                 eax, eax
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   e8????????           |                     

        $sequence_9 = { 2bfa 87fa 5f 8bc2 48 40 }
            // n = 6, score = 1300
            //   2bfa                 | sub                 edi, edx
            //   87fa                 | xchg                edx, edi
            //   5f                   | pop                 edi
            //   8bc2                 | mov                 eax, edx
            //   48                   | dec                 eax
            //   40                   | inc                 eax

    condition:
        7 of them and filesize < 221184
}