rule win_catb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.catb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.catb"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f2805???????? 48898530020000 488d442468 4889442448 }
            // n = 4, score = 100
            //   0f2805????????       |                     
            //   48898530020000       | dec                 eax
            //   488d442468           | lea                 edx, [ebp - 0x54]
            //   4889442448           | dec                 eax

        $sequence_1 = { 83f801 751c 488b4530 488b8888000000 488d05aa0f0100 }
            // n = 5, score = 100
            //   83f801               | dec                 eax
            //   751c                 | mov                 ebx, ecx
            //   488b4530             | dec                 eax
            //   488b8888000000       | lea                 edx, [0x7d6b]
            //   488d05aa0f0100       | dec                 eax

        $sequence_2 = { 418be9 48c1f806 488d0d14e40300 4183e23f 4903e8 498bf0 }
            // n = 6, score = 100
            //   418be9               | jmp                 0x6c0
            //   48c1f806             | dec                 eax
            //   488d0d14e40300       | lea                 edx, [0x134d0]
            //   4183e23f             | test                byte ptr [edx + 0x38], 0x20
            //   4903e8               | je                  0x680
            //   498bf0               | dec                 eax

        $sequence_3 = { 4183f90f 7779 428b8c8e38c80000 4803ce ffe1 660f73fa01 eb65 }
            // n = 7, score = 100
            //   4183f90f             | dec                 esp
            //   7779                 | lea                 edi, [eax + eax*8]
            //   428b8c8e38c80000     | dec                 ecx
            //   4803ce               | mov                 eax, ebp
            //   ffe1                 | dec                 eax
            //   660f73fa01           | lea                 ecx, [0x399c3]
            //   eb65                 | and                 eax, 0x3f

        $sequence_4 = { 48ffc7 803f20 74f8 be05000000 488d151d9f0000 448bc6 488bcf }
            // n = 7, score = 100
            //   48ffc7               | dec                 eax
            //   803f20               | lea                 edx, [0x9f08]
            //   74f8                 | inc                 esp
            //   be05000000           | mov                 eax, esi
            //   488d151d9f0000       | dec                 eax
            //   448bc6               | mov                 ecx, edi
            //   488bcf               | sub                 eax, edx

        $sequence_5 = { 7832 3b0d???????? 732a 4863c9 4c8d05e89f0300 488bc1 }
            // n = 6, score = 100
            //   7832                 | mov                 eax, 0x20b
            //   3b0d????????         |                     
            //   732a                 | dec                 eax
            //   4863c9               | arpl                word ptr [edi], cx
            //   4c8d05e89f0300       | dec                 esp
            //   488bc1               | lea                 edi, [0x3853d]

        $sequence_6 = { 48ffcb ffc2 0fb603 4280bc087098010000 74e3 440fb603 }
            // n = 6, score = 100
            //   48ffcb               | dec                 eax
            //   ffc2                 | lea                 edx, [0x9f50]
            //   0fb603               | dec                 eax
            //   4280bc087098010000     | mov    ecx, edi
            //   74e3                 | jne                 0x34f
            //   440fb603             | dec                 ebp

        $sequence_7 = { 7326 4863c9 488d15a49d0300 488bc1 83e13f }
            // n = 5, score = 100
            //   7326                 | xor                 edx, edx
            //   4863c9               | dec                 esp
            //   488d15a49d0300       | lea                 ebx, [0x36f77]
            //   488bc1               | dec                 ebp
            //   83e13f               | test                ecx, ecx

        $sequence_8 = { 4983ceff 33db 4c8d25e8a10300 895c2420 }
            // n = 4, score = 100
            //   4983ceff             | test                eax, eax
            //   33db                 | dec                 eax
            //   4c8d25e8a10300       | mov                 eax, ebp
            //   895c2420             | dec                 esp

        $sequence_9 = { 44895c2448 81fae9fd0000 0f8570010000 4c8d3d23aaffff 418bd3 }
            // n = 5, score = 100
            //   44895c2448           | mov                 ecx, dword ptr [edi + eax*8 + 0x43e40]
            //   81fae9fd0000         | dec                 ecx
            //   0f8570010000         | mov                 esi, ebx
            //   4c8d3d23aaffff       | dec                 ebx
            //   418bd3               | lea                 eax, [ecx + esi*8]

    condition:
        7 of them and filesize < 593920
}