rule win_chinoxy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chinoxy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chinoxy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bce 43 8d041b 50 e8???????? 85c0 89442428 }
            // n = 7, score = 100
            //   8bce                 | mov                 ecx, esi
            //   43                   | inc                 ebx
            //   8d041b               | lea                 eax, [ebx + ebx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   89442428             | mov                 dword ptr [esp + 0x28], eax

        $sequence_1 = { 83c8ff 5b c3 33c0 85ff 7628 8a0c30 }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   85ff                 | test                edi, edi
            //   7628                 | jbe                 0x2a
            //   8a0c30               | mov                 cl, byte ptr [eax + esi]

        $sequence_2 = { 8bf8 85ff 0f849c000000 68???????? }
            // n = 4, score = 100
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f849c000000         | je                  0xa2
            //   68????????           |                     

        $sequence_3 = { 83bf3420000005 753a e9???????? 68e8030000 8bcf e8???????? 8b44241c }
            // n = 7, score = 100
            //   83bf3420000005       | cmp                 dword ptr [edi + 0x2034], 5
            //   753a                 | jne                 0x3c
            //   e9????????           |                     
            //   68e8030000           | push                0x3e8
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_4 = { 8bf1 57 c7442408???????? 8dbee0010000 85ff 897c240c 740a }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   c7442408????????     |                     
            //   8dbee0010000         | lea                 edi, [esi + 0x1e0]
            //   85ff                 | test                edi, edi
            //   897c240c             | mov                 dword ptr [esp + 0xc], edi
            //   740a                 | je                  0xc

        $sequence_5 = { 8d0498 85ff 8928 7427 ff4e08 eb1b 3b5e18 }
            // n = 7, score = 100
            //   8d0498               | lea                 eax, [eax + ebx*4]
            //   85ff                 | test                edi, edi
            //   8928                 | mov                 dword ptr [eax], ebp
            //   7427                 | je                  0x29
            //   ff4e08               | dec                 dword ptr [esi + 8]
            //   eb1b                 | jmp                 0x1d
            //   3b5e18               | cmp                 ebx, dword ptr [esi + 0x18]

        $sequence_6 = { ff15???????? 8b4c2410 8bc7 5f 5e 64890d00000000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_7 = { 8d8ec8020000 e8???????? 8d86d4020000 8b4c240c 894004 894008 c700???????? }
            // n = 7, score = 100
            //   8d8ec8020000         | lea                 ecx, [esi + 0x2c8]
            //   e8????????           |                     
            //   8d86d4020000         | lea                 eax, [esi + 0x2d4]
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   894004               | mov                 dword ptr [eax + 4], eax
            //   894008               | mov                 dword ptr [eax + 8], eax
            //   c700????????         |                     

        $sequence_8 = { 8bf9 897c2408 8d470c c7470400000000 50 }
            // n = 5, score = 100
            //   8bf9                 | mov                 edi, ecx
            //   897c2408             | mov                 dword ptr [esp + 8], edi
            //   8d470c               | lea                 eax, [edi + 0xc]
            //   c7470400000000       | mov                 dword ptr [edi + 4], 0
            //   50                   | push                eax

        $sequence_9 = { 6aff 6a00 6a00 6a00 6a00 6a00 6a00 }
            // n = 7, score = 100
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 1138688
}