rule win_cmsbrute_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cmsbrute."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cmsbrute"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7518 6a00 6a00 ff75f0 57 56 e8???????? }
            // n = 7, score = 500
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   57                   | push                edi
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_1 = { eb0e 85c0 740f 6835010000 53 6a09 6a06 }
            // n = 7, score = 500
            //   eb0e                 | jmp                 0x10
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   6835010000           | push                0x135
            //   53                   | push                ebx
            //   6a09                 | push                9
            //   6a06                 | push                6

        $sequence_2 = { ff74241c e8???????? 8b44242c 8b4018 8b00 8b10 6a00 }
            // n = 7, score = 500
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   e8????????           |                     
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   8b4018               | mov                 eax, dword ptr [eax + 0x18]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   6a00                 | push                0

        $sequence_3 = { f742fc00040000 8b4d10 53 56 57 8bd8 7568 }
            // n = 7, score = 500
            //   f742fc00040000       | test                dword ptr [edx - 4], 0x400
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bd8                 | mov                 ebx, eax
            //   7568                 | jne                 0x6a

        $sequence_4 = { eb1b 8b866c040000 8945dc 8b8670040000 8b5ddc 8945e4 8b8674040000 }
            // n = 7, score = 500
            //   eb1b                 | jmp                 0x1d
            //   8b866c040000         | mov                 eax, dword ptr [esi + 0x46c]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8b8670040000         | mov                 eax, dword ptr [esi + 0x470]
            //   8b5ddc               | mov                 ebx, dword ptr [ebp - 0x24]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b8674040000         | mov                 eax, dword ptr [esi + 0x474]

        $sequence_5 = { ffb540ffffff 56 e8???????? 8b5718 83c40c 898558ffffff 85d2 }
            // n = 7, score = 500
            //   ffb540ffffff         | push                dword ptr [ebp - 0xc0]
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b5718               | mov                 edx, dword ptr [edi + 0x18]
            //   83c40c               | add                 esp, 0xc
            //   898558ffffff         | mov                 dword ptr [ebp - 0xa8], eax
            //   85d2                 | test                edx, edx

        $sequence_6 = { e9???????? 8bf3 e8???????? ff75fc ebe6 8b4704 85c0 }
            // n = 7, score = 500
            //   e9????????           |                     
            //   8bf3                 | mov                 esi, ebx
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ebe6                 | jmp                 0xffffffe8
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   85c0                 | test                eax, eax

        $sequence_7 = { eb2d 3bd7 7509 397b10 0f8433ffffff 89bdf4fbffff 89b5d8fbffff }
            // n = 7, score = 500
            //   eb2d                 | jmp                 0x2f
            //   3bd7                 | cmp                 edx, edi
            //   7509                 | jne                 0xb
            //   397b10               | cmp                 dword ptr [ebx + 0x10], edi
            //   0f8433ffffff         | je                  0xffffff39
            //   89bdf4fbffff         | mov                 dword ptr [ebp - 0x40c], edi
            //   89b5d8fbffff         | mov                 dword ptr [ebp - 0x428], esi

        $sequence_8 = { f6471801 7411 e8???????? 4b 4e e8???????? a1???????? }
            // n = 7, score = 500
            //   f6471801             | test                byte ptr [edi + 0x18], 1
            //   7411                 | je                  0x13
            //   e8????????           |                     
            //   4b                   | dec                 ebx
            //   4e                   | dec                 esi
            //   e8????????           |                     
            //   a1????????           |                     

        $sequence_9 = { e9???????? f7870001000000000020 740a e8???????? e9???????? 6a32 6a02 }
            // n = 7, score = 500
            //   e9????????           |                     
            //   f7870001000000000020     | test    dword ptr [edi + 0x100], 0x20000000
            //   740a                 | je                  0xc
            //   e8????????           |                     
            //   e9????????           |                     
            //   6a32                 | push                0x32
            //   6a02                 | push                2

    condition:
        7 of them and filesize < 5275648
}