rule win_collection_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.collection_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.collection_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 448928 498b4f10 4885c9 7405 e8???????? }
            // n = 5, score = 100
            //   448928               | mov                 ecx, ebp
            //   498b4f10             | mov                 dword ptr [esp + 0x28], 0x80
            //   4885c9               | mov                 dword ptr [esp + 0x20], 3
            //   7405                 | jmp                 0x547
            //   e8????????           |                     

        $sequence_1 = { 4c8bc0 4889442450 eb05 4c8b442450 }
            // n = 4, score = 100
            //   4c8bc0               | test                ebx, ebx
            //   4889442450           | dec                 eax
            //   eb05                 | mov                 ecx, dword ptr [esp + 0x60]
            //   4c8b442450           | dec                 eax

        $sequence_2 = { 488b05???????? 488b4808 488b4930 4883c110 e8???????? 488b05???????? }
            // n = 6, score = 100
            //   488b05????????       |                     
            //   488b4808             | dec                 esp
            //   488b4930             | lea                 eax, [eax + 0x84]
            //   4883c110             | mov                 eax, dword ptr [eax + 0x80]
            //   e8????????           |                     
            //   488b05????????       |                     

        $sequence_3 = { e8???????? 4883c604 448bc7 488bd6 488bc8 488bd8 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4883c604             | dec                 eax
            //   448bc7               | mov                 dword ptr [esp + 0x40], eax
            //   488bd6               | dec                 eax
            //   488bc8               | lea                 eax, [esp + 0xa0]
            //   488bd8               | dec                 eax

        $sequence_4 = { 85c0 7461 e9???????? 488b9540070000 4c8d0590980000 }
            // n = 5, score = 100
            //   85c0                 | mov                 dword ptr [esp + 0x28], ecx
            //   7461                 | mov                 ecx, 9
            //   e9????????           |                     
            //   488b9540070000       | dec                 eax
            //   4c8d0590980000       | mov                 dword ptr [esp + 0x20], edi

        $sequence_5 = { 84c0 740a 458b949be4350200 eb08 458b949bac350200 448d47ff }
            // n = 6, score = 100
            //   84c0                 | dec                 eax
            //   740a                 | lea                 ecx, [edx + 0x40]
            //   458b949be4350200     | dec                 eax
            //   eb08                 | add                 ecx, 0x20
            //   458b949bac350200     | test                edi, edi
            //   448d47ff             | je                  0x3a0

        $sequence_6 = { 488913 498bfe 895308 4d3bf4 0f8364010000 448a2f 4c8d35843b0100 }
            // n = 7, score = 100
            //   488913               | mov                 al, byte ptr [edi + ecx]
            //   498bfe               | dec                 ebx
            //   895308               | inc                 ecx
            //   4d3bf4               | inc                 ecx
            //   0f8364010000         | mov                 byte ptr [ecx], al
            //   448a2f               | test                ebx, ebx
            //   4c8d35843b0100       | je                  0x74c

        $sequence_7 = { 41b806000000 488d15d7390100 483950f0 740b 488b10 4885d2 7403 }
            // n = 7, score = 100
            //   41b806000000         | mov                 ecx, dword ptr [esp + 0x38]
            //   488d15d7390100       | test                eax, eax
            //   483950f0             | jne                 0x99b
            //   740b                 | dec                 ecx
            //   488b10               | add                 edx, esi
            //   4885d2               | mov                 edi, 0xa62
            //   7403                 | dec                 eax

        $sequence_8 = { 89442420 4c8b8c2480110000 4533c0 8bd3 8d4fe9 e8???????? }
            // n = 6, score = 100
            //   89442420             | lea                 ecx, [ebx + ebx*4]
            //   4c8b8c2480110000     | dec                 eax
            //   4533c0               | sub                 esp, 0x20
            //   8bd3                 | jmp                 0xcfb
            //   8d4fe9               | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 488bc8 bac8000000 e8???????? 488bd0 41b810000000 488bcb 4883c420 }
            // n = 7, score = 100
            //   488bc8               | dec                 eax
            //   bac8000000           | test                eax, eax
            //   e8????????           |                     
            //   488bd0               | je                  0x858
            //   41b810000000         | mov                 ecx, 0x18
            //   488bcb               | xor                 edx, edx
            //   4883c420             | dec                 eax

    condition:
        7 of them and filesize < 397312
}