rule win_contopee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.contopee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.contopee"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? ffd5 8b0d???????? a1???????? 83c408 0bc8 7535 }
            // n = 7, score = 100
            //   68????????           |                     
            //   ffd5                 | call                ebp
            //   8b0d????????         |                     
            //   a1????????           |                     
            //   83c408               | add                 esp, 8
            //   0bc8                 | or                  ecx, eax
            //   7535                 | jne                 0x37

        $sequence_1 = { 89461c 896e24 ff15???????? 83c418 85c0 7437 c7460801000000 }
            // n = 7, score = 100
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   896e24               | mov                 dword ptr [esi + 0x24], ebp
            //   ff15????????         |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   7437                 | je                  0x39
            //   c7460801000000       | mov                 dword ptr [esi + 8], 1

        $sequence_2 = { 52 55 ff15???????? 55 ff15???????? 8d442410 50 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax

        $sequence_3 = { 6a78 50 53 51 e8???????? 83c414 85c0 }
            // n = 7, score = 100
            //   6a78                 | push                0x78
            //   50                   | push                eax
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax

        $sequence_4 = { 66392f 7502 33ff 8d442410 56 }
            // n = 5, score = 100
            //   66392f               | cmp                 word ptr [edi], bp
            //   7502                 | jne                 4
            //   33ff                 | xor                 edi, edi
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   56                   | push                esi

        $sequence_5 = { c1e807 33d2 8a9094130110 8bc2 66ff848688090000 8b869c160000 8b96a0160000 }
            // n = 7, score = 100
            //   c1e807               | shr                 eax, 7
            //   33d2                 | xor                 edx, edx
            //   8a9094130110         | mov                 dl, byte ptr [eax + 0x10011394]
            //   8bc2                 | mov                 eax, edx
            //   66ff848688090000     | inc                 word ptr [esi + eax*4 + 0x988]
            //   8b869c160000         | mov                 eax, dword ptr [esi + 0x169c]
            //   8b96a0160000         | mov                 edx, dword ptr [esi + 0x16a0]

        $sequence_6 = { 89742430 c744242c01000000 89b42434010000 c784243001000001000000 ff15???????? }
            // n = 5, score = 100
            //   89742430             | mov                 dword ptr [esp + 0x30], esi
            //   c744242c01000000     | mov                 dword ptr [esp + 0x2c], 1
            //   89b42434010000       | mov                 dword ptr [esp + 0x134], esi
            //   c784243001000001000000     | mov    dword ptr [esp + 0x130], 1
            //   ff15????????         |                     

        $sequence_7 = { 81c632020000 6a02 56 e8???????? 83c408 b801000000 5f }
            // n = 7, score = 100
            //   81c632020000         | add                 esi, 0x232
            //   6a02                 | push                2
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi

        $sequence_8 = { 85c0 0f859a010000 8b442410 55 56 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f859a010000         | jne                 0x1a0
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   55                   | push                ebp
            //   56                   | push                esi

        $sequence_9 = { 8bf7 8bfa 8d5568 c1e902 f3a5 8bc8 33c0 }
            // n = 7, score = 100
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   8d5568               | lea                 edx, [ebp + 0x68]
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 180224
}