rule win_cookiebag_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cookiebag."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cookiebag"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4c242c 52 55 50 c68424c000000011 }
            // n = 5, score = 100
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   52                   | push                edx
            //   55                   | push                ebp
            //   50                   | push                eax
            //   c68424c000000011     | mov                 byte ptr [esp + 0xc0], 0x11

        $sequence_1 = { 83c9ff f2ae 8b456c f7d1 49 51 }
            // n = 6, score = 100
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8b456c               | mov                 eax, dword ptr [ebp + 0x6c]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   51                   | push                ecx

        $sequence_2 = { 8d4c241c e8???????? 8b442418 c68424a80000000d 3bc3 895c2448 7505 }
            // n = 7, score = 100
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   c68424a80000000d     | mov                 byte ptr [esp + 0xa8], 0xd
            //   3bc3                 | cmp                 eax, ebx
            //   895c2448             | mov                 dword ptr [esp + 0x48], ebx
            //   7505                 | jne                 7

        $sequence_3 = { c7430857000000 6a01 8d8c2480000000 c7842404010000ffffffff e8???????? }
            // n = 5, score = 100
            //   c7430857000000       | mov                 dword ptr [ebx + 8], 0x57
            //   6a01                 | push                1
            //   8d8c2480000000       | lea                 ecx, [esp + 0x80]
            //   c7842404010000ffffffff     | mov    dword ptr [esp + 0x104], 0xffffffff
            //   e8????????           |                     

        $sequence_4 = { 8b4c2450 897c2440 3bcf 897c2444 897c2448 741c }
            // n = 6, score = 100
            //   8b4c2450             | mov                 ecx, dword ptr [esp + 0x50]
            //   897c2440             | mov                 dword ptr [esp + 0x40], edi
            //   3bcf                 | cmp                 ecx, edi
            //   897c2444             | mov                 dword ptr [esp + 0x44], edi
            //   897c2448             | mov                 dword ptr [esp + 0x48], edi
            //   741c                 | je                  0x1e

        $sequence_5 = { 8d4c243c c684248401000005 e8???????? 8b4c241c 33f6 3bce }
            // n = 6, score = 100
            //   8d4c243c             | lea                 ecx, [esp + 0x3c]
            //   c684248401000005     | mov                 byte ptr [esp + 0x184], 5
            //   e8????????           |                     
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   33f6                 | xor                 esi, esi
            //   3bce                 | cmp                 ecx, esi

        $sequence_6 = { 8b6c2408 56 8bf1 57 8a08 55 880e }
            // n = 7, score = 100
            //   8b6c2408             | mov                 ebp, dword ptr [esp + 8]
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   55                   | push                ebp
            //   880e                 | mov                 byte ptr [esi], cl

        $sequence_7 = { 6a01 8d4c2460 c68424ac00000002 e8???????? 8b4c2450 3bcb 741c }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   8d4c2460             | lea                 ecx, [esp + 0x60]
            //   c68424ac00000002     | mov                 byte ptr [esp + 0xac], 2
            //   e8????????           |                     
            //   8b4c2450             | mov                 ecx, dword ptr [esp + 0x50]
            //   3bcb                 | cmp                 ecx, ebx
            //   741c                 | je                  0x1e

        $sequence_8 = { 55 8bce e8???????? 89aedc000000 8b86e4000000 33ff }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   89aedc000000         | mov                 dword ptr [esi + 0xdc], ebp
            //   8b86e4000000         | mov                 eax, dword ptr [esi + 0xe4]
            //   33ff                 | xor                 edi, edi

        $sequence_9 = { eb0c 83c1fe 51 e8???????? 83c404 895e40 895e44 }
            // n = 7, score = 100
            //   eb0c                 | jmp                 0xe
            //   83c1fe               | add                 ecx, -2
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   895e40               | mov                 dword ptr [esi + 0x40], ebx
            //   895e44               | mov                 dword ptr [esi + 0x44], ebx

    condition:
        7 of them and filesize < 311296
}