rule win_croxloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.croxloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.croxloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5b c3 4883ec38 488d05058b0000 41b91b000000 4889442420 }
            // n = 6, score = 100
            //   5b                   | inc                 ecx
            //   c3                   | mov                 ecx, 0x1b
            //   4883ec38             | dec                 eax
            //   488d05058b0000       | mov                 dword ptr [esp + 0x20], eax
            //   41b91b000000         | ret                 
            //   4889442420           | dec                 eax

        $sequence_1 = { 33d2 4889bc2480030000 488bc8 ff15???????? }
            // n = 4, score = 100
            //   33d2                 | movzx               ecx, cl
            //   4889bc2480030000     | inc                 esp
            //   488bc8               | add                 ecx, ecx
            //   ff15????????         |                     

        $sequence_2 = { 0f841f010000 48895c2418 0f1f440000 4d8b5a60 bb05150000 450fb74a58 }
            // n = 6, score = 100
            //   0f841f010000         | dec                 esp
            //   48895c2418           | lea                 eax, [0x7ddc]
            //   0f1f440000           | dec                 eax
            //   4d8b5a60             | lea                 edx, [0x7dd9]
            //   bb05150000           | dec                 eax
            //   450fb74a58           | mov                 ebx, edx

        $sequence_3 = { b95595db6d e8???????? 4c8d05e3890100 ba403a485e b95595db6d e8???????? }
            // n = 6, score = 100
            //   b95595db6d           | mov                 ebx, ecx
            //   e8????????           |                     
            //   4c8d05e3890100       | dec                 esp
            //   ba403a485e           | lea                 ecx, [0xadb1]
            //   b95595db6d           | mov                 ecx, 2
            //   e8????????           |                     

        $sequence_4 = { 4a8b94e010970100 428a4cf23d f6c104 741b 428a44f23e 80e1fb }
            // n = 6, score = 100
            //   4a8b94e010970100     | cmp                 edx, 0xfde9
            //   428a4cf23d           | jne                 0x639
            //   f6c104               | dec                 esp
            //   741b                 | lea                 edi, [0xffff66c7]
            //   428a44f23e           | cmp                 eax, -1
            //   80e1fb               | je                  0x4fa

        $sequence_5 = { 488d0d88f90000 4183e23f 4903e8 498bf0 488b04c1 4b8d14d2 4c8b74d028 }
            // n = 7, score = 100
            //   488d0d88f90000       | dec                 eax
            //   4183e23f             | lea                 eax, [0x12661]
            //   4903e8               | dec                 eax
            //   498bf0               | cmp                 eax, edi
            //   488b04c1             | dec                 eax
            //   4b8d14d2             | sbb                 ecx, ecx
            //   4c8b74d028           | dec                 eax

        $sequence_6 = { 488d05661b0100 488d0d8f1d0100 488905???????? 48890d???????? }
            // n = 4, score = 100
            //   488d05661b0100       | sub                 esp, 0x20
            //   488d0d8f1d0100       | mov                 edi, ecx
            //   488905????????       |                     
            //   48890d????????       |                     

        $sequence_7 = { 488d3d2c290100 eb12 488b03 4885c0 }
            // n = 4, score = 100
            //   488d3d2c290100       | mov                 dword ptr [esp + 0x10], esi
            //   eb12                 | push                edi
            //   488b03               | dec                 esp
            //   4885c0               | mov                 edx, edx

        $sequence_8 = { 895d9b 428844f13e 4b8b84e010970100 42804cf03d04 }
            // n = 4, score = 100
            //   895d9b               | dec                 eax
            //   428844f13e           | lea                 edx, [esp + 0x48]
            //   4b8b84e010970100     | dec                 eax
            //   42804cf03d04         | lea                 eax, [esp + 0x50]

        $sequence_9 = { 488d151eecffff 483bc2 7423 65488b042530000000 488b8998000000 483b4810 7206 }
            // n = 7, score = 100
            //   488d151eecffff       | mov                 eax, 6
            //   483bc2               | dec                 eax
            //   7423                 | lea                 edx, [0x106fb]
            //   65488b042530000000     | dec    eax
            //   488b8998000000       | cmp                 dword ptr [eax - 0x10], edx
            //   483b4810             | je                  0x179d
            //   7206                 | dec                 eax

    condition:
        7 of them and filesize < 241664
}