rule win_cutwail_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cutwail."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cutwail"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d2 f775e8 8b45ec 6a05 }
            // n = 4, score = 100
            //   33d2                 | xor                 edx, edx
            //   f775e8               | div                 dword ptr [ebp - 0x18]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   6a05                 | push                5

        $sequence_1 = { 8b8d64feffff 038d4cfeffff 8b9544feffff 8b048d30f62004 8902 8b8d44feffff 8b9548feffff }
            // n = 7, score = 100
            //   8b8d64feffff         | mov                 ecx, dword ptr [ebp - 0x19c]
            //   038d4cfeffff         | add                 ecx, dword ptr [ebp - 0x1b4]
            //   8b9544feffff         | mov                 edx, dword ptr [ebp - 0x1bc]
            //   8b048d30f62004       | mov                 eax, dword ptr [ecx*4 + 0x420f630]
            //   8902                 | mov                 dword ptr [edx], eax
            //   8b8d44feffff         | mov                 ecx, dword ptr [ebp - 0x1bc]
            //   8b9548feffff         | mov                 edx, dword ptr [ebp - 0x1b8]

        $sequence_2 = { 7434 39750c 762f 2bdf }
            // n = 4, score = 100
            //   7434                 | je                  0x36
            //   39750c               | cmp                 dword ptr [ebp + 0xc], esi
            //   762f                 | jbe                 0x31
            //   2bdf                 | sub                 ebx, edi

        $sequence_3 = { 837d0c00 7406 837d1000 7d04 32c0 eb57 c745fc00000000 }
            // n = 7, score = 100
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   7406                 | je                  8
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7d04                 | jge                 6
            //   32c0                 | xor                 al, al
            //   eb57                 | jmp                 0x59
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_4 = { ff7524 8b7530 8d457c 50 }
            // n = 4, score = 100
            //   ff7524               | push                dword ptr [ebp + 0x24]
            //   8b7530               | mov                 esi, dword ptr [ebp + 0x30]
            //   8d457c               | lea                 eax, [ebp + 0x7c]
            //   50                   | push                eax

        $sequence_5 = { 83c404 8985e4fdffff 6a07 e8???????? 83c404 }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   8985e4fdffff         | mov                 dword ptr [ebp - 0x21c], eax
            //   6a07                 | push                7
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_6 = { 7d07 c68563feffff01 0fb69563feffff 83fa01 }
            // n = 4, score = 100
            //   7d07                 | jge                 9
            //   c68563feffff01       | mov                 byte ptr [ebp - 0x19d], 1
            //   0fb69563feffff       | movzx               edx, byte ptr [ebp - 0x19d]
            //   83fa01               | cmp                 edx, 1

        $sequence_7 = { ff15???????? 8b4dfc c7410400000000 6830750000 ff15???????? 8b55fc }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c7410400000000       | mov                 dword ptr [ecx + 4], 0
            //   6830750000           | push                0x7530
            //   ff15????????         |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_8 = { 0f84ab020000 8b4564 ff30 8b4d4c }
            // n = 4, score = 100
            //   0f84ab020000         | je                  0x2b1
            //   8b4564               | mov                 eax, dword ptr [ebp + 0x64]
            //   ff30                 | push                dword ptr [eax]
            //   8b4d4c               | mov                 ecx, dword ptr [ebp + 0x4c]

        $sequence_9 = { 83c40c 6810270000 ff15???????? 33c0 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_10 = { 7d6e ff15???????? 89855cfeffff 8b8d5cfeffff 3b8d68feffff }
            // n = 5, score = 100
            //   7d6e                 | jge                 0x70
            //   ff15????????         |                     
            //   89855cfeffff         | mov                 dword ptr [ebp - 0x1a4], eax
            //   8b8d5cfeffff         | mov                 ecx, dword ptr [ebp - 0x1a4]
            //   3b8d68feffff         | cmp                 ecx, dword ptr [ebp - 0x198]

        $sequence_11 = { 85c0 8945ec 7425 803b34 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   7425                 | je                  0x27
            //   803b34               | cmp                 byte ptr [ebx], 0x34

        $sequence_12 = { e8???????? 8945f8 837df8ff 7504 32c0 eb27 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df8ff             | cmp                 dword ptr [ebp - 8], -1
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al
            //   eb27                 | jmp                 0x29

        $sequence_13 = { 8b8d5cfeffff 3b8d68feffff 730e 8b955cfeffff 899568feffff eb46 8b8568feffff }
            // n = 7, score = 100
            //   8b8d5cfeffff         | mov                 ecx, dword ptr [ebp - 0x1a4]
            //   3b8d68feffff         | cmp                 ecx, dword ptr [ebp - 0x198]
            //   730e                 | jae                 0x10
            //   8b955cfeffff         | mov                 edx, dword ptr [ebp - 0x1a4]
            //   899568feffff         | mov                 dword ptr [ebp - 0x198], edx
            //   eb46                 | jmp                 0x48
            //   8b8568feffff         | mov                 eax, dword ptr [ebp - 0x198]

        $sequence_14 = { ff75f8 8d8554feffff 56 50 }
            // n = 4, score = 100
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8d8554feffff         | lea                 eax, [ebp - 0x1ac]
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_15 = { 03fb 8b5df0 83c40c ff4df4 }
            // n = 4, score = 100
            //   03fb                 | add                 edi, ebx
            //   8b5df0               | mov                 ebx, dword ptr [ebp - 0x10]
            //   83c40c               | add                 esp, 0xc
            //   ff4df4               | dec                 dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 262144
}