rule win_dadjoke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dadjoke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dadjoke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 57 6800081000 6a00 }
            // n = 4, score = 500
            //   56                   | push                esi
            //   57                   | push                edi
            //   6800081000           | push                0x100800
            //   6a00                 | push                0

        $sequence_1 = { 740a 8b55f4 52 ff15???????? 837df000 740c }
            // n = 6, score = 400
            //   740a                 | je                  0xc
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   740c                 | je                  0xe

        $sequence_2 = { 51 8d5508 52 8d4db8 e8???????? 6a0a 6a00 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   8d5508               | lea                 edx, [ebp + 8]
            //   52                   | push                edx
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e8????????           |                     
            //   6a0a                 | push                0xa
            //   6a00                 | push                0

        $sequence_3 = { f3a5 8bca 83e103 f3a4 a1???????? 8945d0 }
            // n = 6, score = 400
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   a1????????           |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax

        $sequence_4 = { eb39 6800081000 e8???????? 83c404 8945f8 }
            // n = 5, score = 400
            //   eb39                 | jmp                 0x3b
            //   6800081000           | push                0x100800
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_5 = { 6bc200 8b4c05e4 51 e8???????? 83c408 }
            // n = 5, score = 400
            //   6bc200               | imul                eax, edx, 0
            //   8b4c05e4             | mov                 ecx, dword ptr [ebp + eax - 0x1c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_6 = { 8b4580 8bc8 c1e902 f3a5 8bc8 83e103 }
            // n = 6, score = 400
            //   8b4580               | mov                 eax, dword ptr [ebp - 0x80]
            //   8bc8                 | mov                 ecx, eax
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3

        $sequence_7 = { ff15???????? 8945f8 837df800 7c76 8b4d08 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7c76                 | jl                  0x78
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_8 = { 33c9 84c0 0f94c1 8bc1 c3 a1???????? }
            // n = 6, score = 300
            //   33c9                 | xor                 ecx, ecx
            //   84c0                 | test                al, al
            //   0f94c1               | sete                cl
            //   8bc1                 | mov                 eax, ecx
            //   c3                   | ret                 
            //   a1????????           |                     

        $sequence_9 = { ff15???????? 85c0 7417 b920000000 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7417                 | je                  0x19
            //   b920000000           | mov                 ecx, 0x20

        $sequence_10 = { 5e c3 8bff 55 8bec 83ec10 33c0 }
            // n = 7, score = 300
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   33c0                 | xor                 eax, eax

        $sequence_11 = { e8???????? c3 6a04 e8???????? 59 c3 6a0c }
            // n = 7, score = 300
            //   e8????????           |                     
            //   c3                   | ret                 
            //   6a04                 | push                4
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   6a0c                 | push                0xc

        $sequence_12 = { 50 8b08 ff5108 8b85e4faffff 50 8b08 ff5108 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b85e4faffff         | mov                 eax, dword ptr [ebp - 0x51c]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]

        $sequence_13 = { 52 50 8b08 ff5118 8b85e0faffff 50 }
            // n = 6, score = 200
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5118               | call                dword ptr [ecx + 0x18]
            //   8b85e0faffff         | mov                 eax, dword ptr [ebp - 0x520]
            //   50                   | push                eax

        $sequence_14 = { a900000080 7541 d9ec d9c9 d9f1 833d????????00 0f85cc140000 }
            // n = 7, score = 200
            //   a900000080           | test                eax, 0x80000000
            //   7541                 | jne                 0x43
            //   d9ec                 | fldlg2              
            //   d9c9                 | fxch                st(1)
            //   d9f1                 | fyl2x               
            //   833d????????00       |                     
            //   0f85cc140000         | jne                 0x14d2

        $sequence_15 = { 84c0 75f9 8d7d90 2bd6 4f 90 8a4701 }
            // n = 7, score = 200
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   8d7d90               | lea                 edi, [ebp - 0x70]
            //   2bd6                 | sub                 edx, esi
            //   4f                   | dec                 edi
            //   90                   | nop                 
            //   8a4701               | mov                 al, byte ptr [edi + 1]

        $sequence_16 = { 6a00 50 c645f800 e8???????? 83c40c c7458c00000000 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c645f800             | mov                 byte ptr [ebp - 8], 0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c7458c00000000       | mov                 dword ptr [ebp - 0x74], 0

        $sequence_17 = { 6a00 ff15???????? 8b85e0faffff 8d95e8faffff }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8b85e0faffff         | mov                 eax, dword ptr [ebp - 0x520]
            //   8d95e8faffff         | lea                 edx, [ebp - 0x518]

        $sequence_18 = { 6a00 8d4590 50 68???????? 53 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   50                   | push                eax
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_19 = { 8bca 83e103 6a00 f3a4 68???????? ff15???????? 8bf0 }
            // n = 7, score = 200
            //   8bca                 | mov                 ecx, edx
            //   83e103               | and                 ecx, 3
            //   6a00                 | push                0
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_20 = { 8854382a 8b048d58047500 8874382b 8b048d58047500 5a 8854382c eb3b }
            // n = 7, score = 100
            //   8854382a             | mov                 byte ptr [eax + edi + 0x2a], dl
            //   8b048d58047500       | mov                 eax, dword ptr [ecx*4 + 0x750458]
            //   8874382b             | mov                 byte ptr [eax + edi + 0x2b], dh
            //   8b048d58047500       | mov                 eax, dword ptr [ecx*4 + 0x750458]
            //   5a                   | pop                 edx
            //   8854382c             | mov                 byte ptr [eax + edi + 0x2c], dl
            //   eb3b                 | jmp                 0x3d

        $sequence_21 = { 8d85e8fbffff 2bca 50 51 53 }
            // n = 5, score = 100
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   2bca                 | sub                 ecx, edx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_22 = { 833d????????00 0f857c0e0000 8d0da0c37400 ba1b000000 }
            // n = 4, score = 100
            //   833d????????00       |                     
            //   0f857c0e0000         | jne                 0xe82
            //   8d0da0c37400         | lea                 ecx, [0x74c3a0]
            //   ba1b000000           | mov                 edx, 0x1b

    condition:
        7 of them and filesize < 344064
}