rule win_deadwood_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.deadwood."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.deadwood"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 720d 8b4c246c 51 e8???????? 83c404 c68424c000000002 39742460 }
            // n = 7, score = 100
            //   720d                 | jb                  0xf
            //   8b4c246c             | mov                 ecx, dword ptr [esp + 0x6c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c68424c000000002     | mov                 byte ptr [esp + 0xc0], 2
            //   39742460             | cmp                 dword ptr [esp + 0x60], esi

        $sequence_1 = { 8964244c 6aff 56 8d442478 33d2 895914 897110 }
            // n = 7, score = 100
            //   8964244c             | mov                 dword ptr [esp + 0x4c], esp
            //   6aff                 | push                -1
            //   56                   | push                esi
            //   8d442478             | lea                 eax, [esp + 0x78]
            //   33d2                 | xor                 edx, edx
            //   895914               | mov                 dword ptr [ecx + 0x14], ebx
            //   897110               | mov                 dword ptr [ecx + 0x10], esi

        $sequence_2 = { 80780400 7409 8b00 50 ff15???????? c3 8b4808 }
            // n = 7, score = 100
            //   80780400             | cmp                 byte ptr [eax + 4], 0
            //   7409                 | je                  0xb
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   c3                   | ret                 
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]

        $sequence_3 = { 33c0 8d0c5e 668944241c bf07000000 8bc1 897c2430 c744242c00000000 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   8d0c5e               | lea                 ecx, [esi + ebx*2]
            //   668944241c           | mov                 word ptr [esp + 0x1c], ax
            //   bf07000000           | mov                 edi, 7
            //   8bc1                 | mov                 eax, ecx
            //   897c2430             | mov                 dword ptr [esp + 0x30], edi
            //   c744242c00000000     | mov                 dword ptr [esp + 0x2c], 0

        $sequence_4 = { 8b4608 2b06 c1f803 3bc1 734e 53 57 }
            // n = 7, score = 100
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   2b06                 | sub                 eax, dword ptr [esi]
            //   c1f803               | sar                 eax, 3
            //   3bc1                 | cmp                 eax, ecx
            //   734e                 | jae                 0x50
            //   53                   | push                ebx
            //   57                   | push                edi

        $sequence_5 = { ff15???????? 6804010000 8d8df4fdffff 51 50 ff15???????? 33d2 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   6804010000           | push                0x104
            //   8d8df4fdffff         | lea                 ecx, [ebp - 0x20c]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx

        $sequence_6 = { 33c1 a9ff070000 0f94c3 84db 7430 a900008000 740c }
            // n = 7, score = 100
            //   33c1                 | xor                 eax, ecx
            //   a9ff070000           | test                eax, 0x7ff
            //   0f94c3               | sete                bl
            //   84db                 | test                bl, bl
            //   7430                 | je                  0x32
            //   a900008000           | test                eax, 0x800000
            //   740c                 | je                  0xe

        $sequence_7 = { 6689955cffffff 39bd54ffffff 720f 8b8540ffffff 50 e8???????? 83c404 }
            // n = 7, score = 100
            //   6689955cffffff       | mov                 word ptr [ebp - 0xa4], dx
            //   39bd54ffffff         | cmp                 dword ptr [ebp - 0xac], edi
            //   720f                 | jb                  0x11
            //   8b8540ffffff         | mov                 eax, dword ptr [ebp - 0xc0]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_8 = { 8b4204 8d48f8 57 56 c744242402000000 894c301c e8???????? }
            // n = 7, score = 100
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   8d48f8               | lea                 ecx, [eax - 8]
            //   57                   | push                edi
            //   56                   | push                esi
            //   c744242402000000     | mov                 dword ptr [esp + 0x24], 2
            //   894c301c             | mov                 dword ptr [eax + esi + 0x1c], ecx
            //   e8????????           |                     

        $sequence_9 = { c7411407000000 c7411000000000 89a5d8feffff 668911 8d7802 668b10 83c002 }
            // n = 7, score = 100
            //   c7411407000000       | mov                 dword ptr [ecx + 0x14], 7
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   89a5d8feffff         | mov                 dword ptr [ebp - 0x128], esp
            //   668911               | mov                 word ptr [ecx], dx
            //   8d7802               | lea                 edi, [eax + 2]
            //   668b10               | mov                 dx, word ptr [eax]
            //   83c002               | add                 eax, 2

    condition:
        7 of them and filesize < 1055744
}