rule win_diztakun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.diztakun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.diztakun"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8b01 ffd0 8b442404 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ffd0                 | call                eax
            //   8b442404             | mov                 eax, dword ptr [esp + 4]

        $sequence_1 = { 89842410020000 57 a1???????? 33c4 50 8d84241c020000 64a300000000 }
            // n = 7, score = 100
            //   89842410020000       | mov                 dword ptr [esp + 0x210], eax
            //   57                   | push                edi
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   50                   | push                eax
            //   8d84241c020000       | lea                 eax, [esp + 0x21c]
            //   64a300000000         | mov                 dword ptr fs:[0], eax

        $sequence_2 = { 7469 85ff 7465 8b442440 85c0 }
            // n = 5, score = 100
            //   7469                 | je                  0x6b
            //   85ff                 | test                edi, edi
            //   7465                 | je                  0x67
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]
            //   85c0                 | test                eax, eax

        $sequence_3 = { 8b7710 8b04b5a4914400 53 6a04 ff75f0 99 ff75ec }
            // n = 7, score = 100
            //   8b7710               | mov                 esi, dword ptr [edi + 0x10]
            //   8b04b5a4914400       | mov                 eax, dword ptr [esi*4 + 0x4491a4]
            //   53                   | push                ebx
            //   6a04                 | push                4
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   99                   | cdq                 
            //   ff75ec               | push                dword ptr [ebp - 0x14]

        $sequence_4 = { 8b4de0 8d0c8d60d74400 8901 8305????????20 8d9000080000 }
            // n = 5, score = 100
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8d0c8d60d74400       | lea                 ecx, [ecx*4 + 0x44d760]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8305????????20       |                     
            //   8d9000080000         | lea                 edx, [eax + 0x800]

        $sequence_5 = { 8b2d???????? 52 ffd5 85db 7435 8d442414 50 }
            // n = 7, score = 100
            //   8b2d????????         |                     
            //   52                   | push                edx
            //   ffd5                 | call                ebp
            //   85db                 | test                ebx, ebx
            //   7435                 | je                  0x37
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax

        $sequence_6 = { 51 8d542420 52 50 50 50 50 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   52                   | push                edx
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_7 = { b8???????? a3???????? c705????????4fd34200 c705????????03d34200 }
            // n = 4, score = 100
            //   b8????????           |                     
            //   a3????????           |                     
            //   c705????????4fd34200     |     
            //   c705????????03d34200     |     

        $sequence_8 = { 8bcc 8964241c 50 e8???????? 51 8bcc 89642434 }
            // n = 7, score = 100
            //   8bcc                 | mov                 ecx, esp
            //   8964241c             | mov                 dword ptr [esp + 0x1c], esp
            //   50                   | push                eax
            //   e8????????           |                     
            //   51                   | push                ecx
            //   8bcc                 | mov                 ecx, esp
            //   89642434             | mov                 dword ptr [esp + 0x34], esp

        $sequence_9 = { 8b1f 6a00 8dafa8000000 6a03 c7450000000000 e8???????? 8b5354 }
            // n = 7, score = 100
            //   8b1f                 | mov                 ebx, dword ptr [edi]
            //   6a00                 | push                0
            //   8dafa8000000         | lea                 ebp, [edi + 0xa8]
            //   6a03                 | push                3
            //   c7450000000000       | mov                 dword ptr [ebp], 0
            //   e8????????           |                     
            //   8b5354               | mov                 edx, dword ptr [ebx + 0x54]

    condition:
        7 of them and filesize < 688128
}