rule win_faketc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.faketc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.faketc"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 837c245c08 885c2418 895c2428 897c242c 720d }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837c245c08           | cmp                 dword ptr [esp + 0x5c], 8
            //   885c2418             | mov                 byte ptr [esp + 0x18], bl
            //   895c2428             | mov                 dword ptr [esp + 0x28], ebx
            //   897c242c             | mov                 dword ptr [esp + 0x2c], edi
            //   720d                 | jb                  0xf

        $sequence_1 = { ff15???????? a1???????? 50 68af130000 53 ffd7 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   a1????????           |                     
            //   50                   | push                eax
            //   68af130000           | push                0x13af
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   50                   | push                eax

        $sequence_2 = { 8b450c 894218 8b4dfc c7412001000000 eb04 33c0 eb1e }
            // n = 7, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   894218               | mov                 dword ptr [edx + 0x18], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c7412001000000       | mov                 dword ptr [ecx + 0x20], 1
            //   eb04                 | jmp                 6
            //   33c0                 | xor                 eax, eax
            //   eb1e                 | jmp                 0x20

        $sequence_3 = { e8???????? 83c40c 397d08 7454 8b85ccfbffff be10000000 39b5e0fbffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   397d08               | cmp                 dword ptr [ebp + 8], edi
            //   7454                 | je                  0x56
            //   8b85ccfbffff         | mov                 eax, dword ptr [ebp - 0x434]
            //   be10000000           | mov                 esi, 0x10
            //   39b5e0fbffff         | cmp                 dword ptr [ebp - 0x420], esi

        $sequence_4 = { ff5510 83c408 3bf4 e8???????? 85c0 7423 8b4d08 }
            // n = 7, score = 100
            //   ff5510               | call                dword ptr [ebp + 0x10]
            //   83c408               | add                 esp, 8
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7423                 | je                  0x25
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_5 = { c7430401000000 c70301000000 8d9b00000000 8b13 8bc2 33c9 6bc02c }
            // n = 7, score = 100
            //   c7430401000000       | mov                 dword ptr [ebx + 4], 1
            //   c70301000000         | mov                 dword ptr [ebx], 1
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   8bc2                 | mov                 eax, edx
            //   33c9                 | xor                 ecx, ecx
            //   6bc02c               | imul                eax, eax, 0x2c

        $sequence_6 = { 8b049518e85f00 33049d18e85f00 c1ef10 81e7ff000000 3304bd18e45f00 899c2498000000 3304ad18dc5f00 }
            // n = 7, score = 100
            //   8b049518e85f00       | mov                 eax, dword ptr [edx*4 + 0x5fe818]
            //   33049d18e85f00       | xor                 eax, dword ptr [ebx*4 + 0x5fe818]
            //   c1ef10               | shr                 edi, 0x10
            //   81e7ff000000         | and                 edi, 0xff
            //   3304bd18e45f00       | xor                 eax, dword ptr [edi*4 + 0x5fe418]
            //   899c2498000000       | mov                 dword ptr [esp + 0x98], ebx
            //   3304ad18dc5f00       | xor                 eax, dword ptr [ebp*4 + 0x5fdc18]

        $sequence_7 = { e8???????? a3???????? 68fa030000 57 ffd3 6a00 6a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   a3????????           |                     
            //   68fa030000           | push                0x3fa
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { d1e9 33ed 0be8 8b442470 c1e31f 0bd9 8b4c2474 }
            // n = 7, score = 100
            //   d1e9                 | shr                 ecx, 1
            //   33ed                 | xor                 ebp, ebp
            //   0be8                 | or                  ebp, eax
            //   8b442470             | mov                 eax, dword ptr [esp + 0x70]
            //   c1e31f               | shl                 ebx, 0x1f
            //   0bd9                 | or                  ebx, ecx
            //   8b4c2474             | mov                 ecx, dword ptr [esp + 0x74]

        $sequence_9 = { e8???????? 83c408 83bdd8fdffff00 7516 8b85d4fdffff 50 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   83bdd8fdffff00       | cmp                 dword ptr [ebp - 0x228], 0
            //   7516                 | jne                 0x18
            //   8b85d4fdffff         | mov                 eax, dword ptr [ebp - 0x22c]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 6864896
}