rule win_fishmaster_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fishmaster."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fishmaster"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 410fbe4c0101 8d41bf 3c19 7705 8d69bf eb28 }
            // n = 6, score = 100
            //   410fbe4c0101         | inc                 ecx
            //   8d41bf               | cmove               edx, edx
            //   3c19                 | mov                 edx, edi
            //   7705                 | jmp                 0x531
            //   8d69bf               | mov                 edx, dword ptr [esp + 0x98]
            //   eb28                 | cmp                 cl, 0x2f

        $sequence_1 = { 4489442420 488bcb 488b4318 4883f810 7203 488b0b }
            // n = 6, score = 100
            //   4489442420           | ret                 
            //   488bcb               | ret                 
            //   488b4318             | dec                 eax
            //   4883f810             | lea                 eax, [0x2a5d]
            //   7203                 | ret                 
            //   488b0b               | dec                 eax

        $sequence_2 = { 448d5701 4885c0 0f8e17030000 4d8bcc 4c89642428 448bac2498000000 }
            // n = 6, score = 100
            //   448d5701             | inc                 esp
            //   4885c0               | movzx               eax, word ptr [ebp - 0x2c]
            //   0f8e17030000         | int3                
            //   4d8bcc               | dec                 eax
            //   4c89642428           | test                ecx, ecx
            //   448bac2498000000     | je                  0x19d

        $sequence_3 = { 7203 488b0b 488bd5 4889542438 }
            // n = 4, score = 100
            //   7203                 | dec                 esp
            //   488b0b               | mov                 dword ptr [esp + 0x30], esi
            //   488bd5               | dec                 eax
            //   4889542438           | mov                 ecx, eax

        $sequence_4 = { 8d41bf 41b83f000000 3c19 7706 448d61bf eb2b }
            // n = 6, score = 100
            //   8d41bf               | dec                 ecx
            //   41b83f000000         | sub                 eax, esi
            //   3c19                 | dec                 eax
            //   7706                 | cmp                 eax, edx
            //   448d61bf             | jb                  0x1d96
            //   eb2b                 | dec                 eax

        $sequence_5 = { 4533c9 33d2 458d4103 488d0dc51e0000 ff15???????? 4c89742438 488d4c2468 }
            // n = 7, score = 100
            //   4533c9               | dec                 ebp
            //   33d2                 | mov                 eax, dword ptr [esi + 0x18]
            //   458d4103             | inc                 ecx
            //   488d0dc51e0000       | cmp                 al, 0x2f
            //   ff15????????         |                     
            //   4c89742438           | inc                 ecx
            //   488d4c2468           | cmove               ecx, edi

        $sequence_6 = { 7705 8d71bf eb28 8d419f 3c19 }
            // n = 5, score = 100
            //   7705                 | mov                 dword ptr [ebp - 8], eax
            //   8d71bf               | dec                 eax
            //   eb28                 | lea                 eax, [ebp + 0xff0]
            //   8d419f               | dec                 eax
            //   3c19                 | mov                 dword ptr [ebp - 0x28], eax

        $sequence_7 = { ff15???????? cc 4885c9 7407 e8???????? eb02 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   cc                   | lea                 eax, [esp + 0x40]
            //   4885c9               | dec                 eax
            //   7407                 | cmp                 dword ptr [esp + 0x58], 0x10
            //   e8????????           |                     
            //   eb02                 | dec                 eax

        $sequence_8 = { 482bc5 4883c0f8 4883f81f 7607 ff15???????? }
            // n = 5, score = 100
            //   482bc5               | lea                 esi, [ecx + 4]
            //   4883c0f8             | jmp                 0x435
            //   4883f81f             | cmp                 cl, 0x2b
            //   7607                 | cmp                 al, 9
            //   ff15????????         |                     

        $sequence_9 = { 4883f801 721c 488d4101 48894310 4883fa10 488bc3 7203 }
            // n = 7, score = 100
            //   4883f801             | dec                 eax
            //   721c                 | add                 esi, 3
            //   488d4101             | dec                 ecx
            //   48894310             | cmp                 esi, esp
            //   4883fa10             | inc                 esp
            //   488bc3               | mov                 byte ptr [eax + ecx], cl
            //   7203                 | mov                 byte ptr [eax + ecx + 1], 0

    condition:
        7 of them and filesize < 812032
}