rule win_freenki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.freenki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.freenki"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e03f 6bc830 8b049578394200 c644082801 897de4 c745fcfeffffff }
            // n = 6, score = 200
            //   83e03f               | and                 eax, 0x3f
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049578394200       | mov                 eax, dword ptr [edx*4 + 0x423978]
            //   c644082801           | mov                 byte ptr [eax + ecx + 0x28], 1
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   c745fcfeffffff       | mov                 dword ptr [ebp - 4], 0xfffffffe

        $sequence_1 = { 83c404 8d8570feffff 50 8d8570fdffff }
            // n = 4, score = 200
            //   83c404               | add                 esp, 4
            //   8d8570feffff         | lea                 eax, [ebp - 0x190]
            //   50                   | push                eax
            //   8d8570fdffff         | lea                 eax, [ebp - 0x290]

        $sequence_2 = { 56 e8???????? 8bf8 83c408 85ff 7598 8b4dfc }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c408               | add                 esp, 8
            //   85ff                 | test                edi, edi
            //   7598                 | jne                 0xffffff9a
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_3 = { 68???????? 50 ff5110 8b55b8 8b4dcc 2bd1 0f1f440000 }
            // n = 7, score = 200
            //   68????????           |                     
            //   50                   | push                eax
            //   ff5110               | call                dword ptr [ecx + 0x10]
            //   8b55b8               | mov                 edx, dword ptr [ebp - 0x48]
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   2bd1                 | sub                 edx, ecx
            //   0f1f440000           | nop                 dword ptr [eax + eax]

        $sequence_4 = { 6a00 6a03 6a00 6a00 57 8d85f8ceffff 50 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   57                   | push                edi
            //   8d85f8ceffff         | lea                 eax, [ebp - 0x3108]
            //   50                   | push                eax

        $sequence_5 = { 0f1005???????? 6a00 57 0f11044f f30f7e05???????? 660fd6444f10 a1???????? }
            // n = 7, score = 200
            //   0f1005????????       |                     
            //   6a00                 | push                0
            //   57                   | push                edi
            //   0f11044f             | movups              xmmword ptr [edi + ecx*2], xmm0
            //   f30f7e05????????     |                     
            //   660fd6444f10         | movq                qword ptr [edi + ecx*2 + 0x10], xmm0
            //   a1????????           |                     

        $sequence_6 = { 83c404 85db 747c 53 56 6a00 }
            // n = 6, score = 200
            //   83c404               | add                 esp, 4
            //   85db                 | test                ebx, ebx
            //   747c                 | je                  0x7e
            //   53                   | push                ebx
            //   56                   | push                esi
            //   6a00                 | push                0

        $sequence_7 = { 8b8560ffffff 83c404 8b08 50 }
            // n = 4, score = 200
            //   8b8560ffffff         | mov                 eax, dword ptr [ebp - 0xa0]
            //   83c404               | add                 esp, 4
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax

        $sequence_8 = { 85db 747c 53 56 }
            // n = 4, score = 200
            //   85db                 | test                ebx, ebx
            //   747c                 | je                  0x7e
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_9 = { 8bd7 c1fa06 8bc7 83e03f 6bc830 8b049578394200 f644082801 }
            // n = 7, score = 200
            //   8bd7                 | mov                 edx, edi
            //   c1fa06               | sar                 edx, 6
            //   8bc7                 | mov                 eax, edi
            //   83e03f               | and                 eax, 0x3f
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b049578394200       | mov                 eax, dword ptr [edx*4 + 0x423978]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1

    condition:
        7 of them and filesize < 327680
}