rule win_getmypass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.getmypass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.getmypass"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8de8f9ffff 51 8b95ecfbffff 52 e8???????? }
            // n = 5, score = 200
            //   8d8de8f9ffff         | lea                 ecx, [ebp - 0x618]
            //   51                   | push                ecx
            //   8b95ecfbffff         | mov                 edx, dword ptr [ebp - 0x414]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_1 = { 83c404 85c0 7502 eb0b 8b4dfc 83c101 }
            // n = 6, score = 200
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb0b                 | jmp                 0xd
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c101               | add                 ecx, 1

        $sequence_2 = { 7d34 8b5508 0395f0feffff 0fbe02 83e830 8985f4feffff 8b8df4feffff }
            // n = 7, score = 200
            //   7d34                 | jge                 0x36
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0395f0feffff         | add                 edx, dword ptr [ebp - 0x110]
            //   0fbe02               | movsx               eax, byte ptr [edx]
            //   83e830               | sub                 eax, 0x30
            //   8985f4feffff         | mov                 dword ptr [ebp - 0x10c], eax
            //   8b8df4feffff         | mov                 ecx, dword ptr [ebp - 0x10c]

        $sequence_3 = { 0f85b4020000 837d9819 0f86aa020000 c745a400000000 8b55e0 83ea01 }
            // n = 6, score = 200
            //   0f85b4020000         | jne                 0x2ba
            //   837d9819             | cmp                 dword ptr [ebp - 0x68], 0x19
            //   0f86aa020000         | jbe                 0x2b0
            //   c745a400000000       | mov                 dword ptr [ebp - 0x5c], 0
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   83ea01               | sub                 edx, 1

        $sequence_4 = { 0fb61411 33c2 8b4d14 034df0 }
            // n = 4, score = 200
            //   0fb61411             | movzx               edx, byte ptr [ecx + edx]
            //   33c2                 | xor                 eax, edx
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]

        $sequence_5 = { 8d4dfc 51 8b55f4 52 8b45f0 50 }
            // n = 6, score = 200
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   50                   | push                eax

        $sequence_6 = { 0f8428010000 8b5508 52 e8???????? 83c404 0fb6c0 }
            // n = 6, score = 200
            //   0f8428010000         | je                  0x12e
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   0fb6c0               | movzx               eax, al

        $sequence_7 = { 6a00 ff15???????? eb14 8b45a0 50 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   eb14                 | jmp                 0x16
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]
            //   50                   | push                eax

        $sequence_8 = { 7467 b9???????? e8???????? 8b4dfc 51 8b55f8 52 }
            // n = 7, score = 200
            //   7467                 | je                  0x69
            //   b9????????           |                     
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   52                   | push                edx

        $sequence_9 = { 80c201 8b85f4feffff 889405f8feffff ebb4 c745fc00000000 }
            // n = 5, score = 200
            //   80c201               | add                 dl, 1
            //   8b85f4feffff         | mov                 eax, dword ptr [ebp - 0x10c]
            //   889405f8feffff       | mov                 byte ptr [ebp + eax - 0x108], dl
            //   ebb4                 | jmp                 0xffffffb6
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

    condition:
        7 of them and filesize < 49152
}