rule win_ghost_secret_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ghost_secret."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghost_secret"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c684244a04000036 c684244b040000e2 c684244c04000057 c684244d04000049 c684244e0400002c c684244f040000f6 c684245004000070 }
            // n = 7, score = 200
            //   c684244a04000036     | mov                 byte ptr [esp + 0x44a], 0x36
            //   c684244b040000e2     | mov                 byte ptr [esp + 0x44b], 0xe2
            //   c684244c04000057     | mov                 byte ptr [esp + 0x44c], 0x57
            //   c684244d04000049     | mov                 byte ptr [esp + 0x44d], 0x49
            //   c684244e0400002c     | mov                 byte ptr [esp + 0x44e], 0x2c
            //   c684244f040000f6     | mov                 byte ptr [esp + 0x44f], 0xf6
            //   c684245004000070     | mov                 byte ptr [esp + 0x450], 0x70

        $sequence_1 = { 85c0 59 0f8547010000 837e5816 740a b80088ffff }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   0f8547010000         | jne                 0x14d
            //   837e5816             | cmp                 dword ptr [esi + 0x58], 0x16
            //   740a                 | je                  0xc
            //   b80088ffff           | mov                 eax, 0xffff8800

        $sequence_2 = { c684245b040000ec c684245c04000067 c684245d04000052 c684245e04000007 c684245f040000f0 c684246004000070 c684246104000065 }
            // n = 7, score = 200
            //   c684245b040000ec     | mov                 byte ptr [esp + 0x45b], 0xec
            //   c684245c04000067     | mov                 byte ptr [esp + 0x45c], 0x67
            //   c684245d04000052     | mov                 byte ptr [esp + 0x45d], 0x52
            //   c684245e04000007     | mov                 byte ptr [esp + 0x45e], 7
            //   c684245f040000f0     | mov                 byte ptr [esp + 0x45f], 0xf0
            //   c684246004000070     | mov                 byte ptr [esp + 0x460], 0x70
            //   c684246104000065     | mov                 byte ptr [esp + 0x461], 0x65

        $sequence_3 = { 55 ff15???????? 8b942450020000 52 e8???????? 8b8c2454020000 8be8 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   8b942450020000       | mov                 edx, dword ptr [esp + 0x250]
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b8c2454020000       | mov                 ecx, dword ptr [esp + 0x254]
            //   8be8                 | mov                 ebp, eax

        $sequence_4 = { c1e208 0fb69bc4f04100 33d3 33db 8a5df2 3316 0fb69bc4f04100 }
            // n = 7, score = 200
            //   c1e208               | shl                 edx, 8
            //   0fb69bc4f04100       | movzx               ebx, byte ptr [ebx + 0x41f0c4]
            //   33d3                 | xor                 edx, ebx
            //   33db                 | xor                 ebx, ebx
            //   8a5df2               | mov                 bl, byte ptr [ebp - 0xe]
            //   3316                 | xor                 edx, dword ptr [esi]
            //   0fb69bc4f04100       | movzx               ebx, byte ptr [ebx + 0x41f0c4]

        $sequence_5 = { ff7648 e8???????? 57 55 ff766c e8???????? }
            // n = 6, score = 200
            //   ff7648               | push                dword ptr [esi + 0x48]
            //   e8????????           |                     
            //   57                   | push                edi
            //   55                   | push                ebp
            //   ff766c               | push                dword ptr [esi + 0x6c]
            //   e8????????           |                     

        $sequence_6 = { 8bf0 85f6 741f 8d842434040000 6a10 50 }
            // n = 6, score = 200
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   741f                 | je                  0x21
            //   8d842434040000       | lea                 eax, [esp + 0x434]
            //   6a10                 | push                0x10
            //   50                   | push                eax

        $sequence_7 = { c684244b05000059 c684244c05000013 c684244d050000b9 c684244e050000f3 888c244f050000 c684245005000046 }
            // n = 6, score = 200
            //   c684244b05000059     | mov                 byte ptr [esp + 0x54b], 0x59
            //   c684244c05000013     | mov                 byte ptr [esp + 0x54c], 0x13
            //   c684244d050000b9     | mov                 byte ptr [esp + 0x54d], 0xb9
            //   c684244e050000f3     | mov                 byte ptr [esp + 0x54e], 0xf3
            //   888c244f050000       | mov                 byte ptr [esp + 0x54f], cl
            //   c684245005000046     | mov                 byte ptr [esp + 0x550], 0x46

        $sequence_8 = { 331c8dc4d34100 59 331c85c4db4100 8b45f8 23c7 331c85c4cf4100 331e }
            // n = 7, score = 200
            //   331c8dc4d34100       | xor                 ebx, dword ptr [ecx*4 + 0x41d3c4]
            //   59                   | pop                 ecx
            //   331c85c4db4100       | xor                 ebx, dword ptr [eax*4 + 0x41dbc4]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   23c7                 | and                 eax, edi
            //   331c85c4cf4100       | xor                 ebx, dword ptr [eax*4 + 0x41cfc4]
            //   331e                 | xor                 ebx, dword ptr [esi]

        $sequence_9 = { c644245d25 c644245e60 c644245f55 c6442460d5 c64424615a c644246232 884c2467 }
            // n = 7, score = 200
            //   c644245d25           | mov                 byte ptr [esp + 0x5d], 0x25
            //   c644245e60           | mov                 byte ptr [esp + 0x5e], 0x60
            //   c644245f55           | mov                 byte ptr [esp + 0x5f], 0x55
            //   c6442460d5           | mov                 byte ptr [esp + 0x60], 0xd5
            //   c64424615a           | mov                 byte ptr [esp + 0x61], 0x5a
            //   c644246232           | mov                 byte ptr [esp + 0x62], 0x32
            //   884c2467             | mov                 byte ptr [esp + 0x67], cl

    condition:
        7 of them and filesize < 278528
}