rule win_ginwui_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ginwui"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66c745e40100 c745e001000000 8d45a4 50 }
            // n = 4, score = 300
            //   66c745e40100         | mov                 word ptr [ebp - 0x1c], 1
            //   c745e001000000       | mov                 dword ptr [ebp - 0x20], 1
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax

        $sequence_1 = { 80f939 7718 81e1ff000000 83e930 03db 8d1c9b 03cb }
            // n = 7, score = 300
            //   80f939               | cmp                 cl, 0x39
            //   7718                 | ja                  0x1a
            //   81e1ff000000         | and                 ecx, 0xff
            //   83e930               | sub                 ecx, 0x30
            //   03db                 | add                 ebx, ebx
            //   8d1c9b               | lea                 ebx, [ebx + ebx*4]
            //   03cb                 | add                 ecx, ebx

        $sequence_2 = { b301 8938 896804 8bc3 83c420 }
            // n = 5, score = 300
            //   b301                 | mov                 bl, 1
            //   8938                 | mov                 dword ptr [eax], edi
            //   896804               | mov                 dword ptr [eax + 4], ebp
            //   8bc3                 | mov                 eax, ebx
            //   83c420               | add                 esp, 0x20

        $sequence_3 = { e8???????? 89851cefffff 68???????? 68???????? e8???????? }
            // n = 5, score = 300
            //   e8????????           |                     
            //   89851cefffff         | mov                 dword ptr [ebp - 0x10e4], eax
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_4 = { 899ddceeffff 899de0eeffff 895de8 894df4 }
            // n = 4, score = 300
            //   899ddceeffff         | mov                 dword ptr [ebp - 0x1124], ebx
            //   899de0eeffff         | mov                 dword ptr [ebp - 0x1120], ebx
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_5 = { 50 6800100000 8d85a4efffff 50 56 8b45a4 50 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   6800100000           | push                0x1000
            //   8d85a4efffff         | lea                 eax, [ebp - 0x105c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   8b45a4               | mov                 eax, dword ptr [ebp - 0x5c]
            //   50                   | push                eax

        $sequence_6 = { 6a04 8d45ec 50 6805100000 68ffff0000 8b4304 50 }
            // n = 7, score = 300
            //   6a04                 | push                4
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   6805100000           | push                0x1005
            //   68ffff0000           | push                0xffff
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   50                   | push                eax

        $sequence_7 = { 8985f0feffff 60 8965fc 8d85fbfeffff ffb5f4feffff ffb5f0feffff 50 }
            // n = 7, score = 300
            //   8985f0feffff         | mov                 dword ptr [ebp - 0x110], eax
            //   60                   | pushal              
            //   8965fc               | mov                 dword ptr [ebp - 4], esp
            //   8d85fbfeffff         | lea                 eax, [ebp - 0x105]
            //   ffb5f4feffff         | push                dword ptr [ebp - 0x10c]
            //   ffb5f0feffff         | push                dword ptr [ebp - 0x110]
            //   50                   | push                eax

        $sequence_8 = { 48 75f6 8b842400200000 81c470ffffff 8bd8 8bfc 8d942414200000 }
            // n = 7, score = 300
            //   48                   | dec                 eax
            //   75f6                 | jne                 0xfffffff8
            //   8b842400200000       | mov                 eax, dword ptr [esp + 0x2000]
            //   81c470ffffff         | add                 esp, 0xffffff70
            //   8bd8                 | mov                 ebx, eax
            //   8bfc                 | mov                 edi, esp
            //   8d942414200000       | lea                 edx, [esp + 0x2014]

        $sequence_9 = { 7412 3b45f4 7c2f 8b45fc 80782900 0f84c5feffff 837df000 }
            // n = 7, score = 300
            //   7412                 | je                  0x14
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]
            //   7c2f                 | jl                  0x31
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   80782900             | cmp                 byte ptr [eax + 0x29], 0
            //   0f84c5feffff         | je                  0xfffffecb
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0

    condition:
        7 of them and filesize < 196608
}