rule win_goldbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.goldbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.goldbackdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d 5b 83c414 c3 6818010000 eb1a 680c010000 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   83c414               | add                 esp, 0x14
            //   c3                   | ret                 
            //   6818010000           | push                0x118
            //   eb1a                 | jmp                 0x1c
            //   680c010000           | push                0x10c

        $sequence_1 = { 8d4c2448 51 50 e8???????? 83c414 85c0 0f8ebd000000 }
            // n = 7, score = 100
            //   8d4c2448             | lea                 ecx, [esp + 0x48]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   0f8ebd000000         | jle                 0xc3

        $sequence_2 = { 8b5d08 8d4dc4 ba01000000 c7459400000000 e8???????? c745fc00000000 ff03 }
            // n = 7, score = 100
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8d4dc4               | lea                 ecx, [ebp - 0x3c]
            //   ba01000000           | mov                 edx, 1
            //   c7459400000000       | mov                 dword ptr [ebp - 0x6c], 0
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   ff03                 | inc                 dword ptr [ebx]

        $sequence_3 = { 50 e8???????? c745d800001000 c745dc00000000 c745e001000000 83c408 c645fc03 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   c745d800001000       | mov                 dword ptr [ebp - 0x28], 0x100000
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   c745e001000000       | mov                 dword ptr [ebp - 0x20], 1
            //   83c408               | add                 esp, 8
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3

        $sequence_4 = { 83c408 99 83e207 03c2 c1f803 8944241c 3bc7 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   99                   | cdq                 
            //   83e207               | and                 edx, 7
            //   03c2                 | add                 eax, edx
            //   c1f803               | sar                 eax, 3
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   3bc7                 | cmp                 eax, edi

        $sequence_5 = { eb1c a802 740a c74424142b000000 eb0e a804 }
            // n = 6, score = 100
            //   eb1c                 | jmp                 0x1e
            //   a802                 | test                al, 2
            //   740a                 | je                  0xc
            //   c74424142b000000     | mov                 dword ptr [esp + 0x14], 0x2b
            //   eb0e                 | jmp                 0x10
            //   a804                 | test                al, 4

        $sequence_6 = { 47 8bc7 897a04 c1e818 33c6 c1ee08 0fb6c0 }
            // n = 7, score = 100
            //   47                   | inc                 edi
            //   8bc7                 | mov                 eax, edi
            //   897a04               | mov                 dword ptr [edx + 4], edi
            //   c1e818               | shr                 eax, 0x18
            //   33c6                 | xor                 eax, esi
            //   c1ee08               | shr                 esi, 8
            //   0fb6c0               | movzx               eax, al

        $sequence_7 = { 7e28 8b6c2460 33ff 8b5c2430 8bc7 47 99 }
            // n = 7, score = 100
            //   7e28                 | jle                 0x2a
            //   8b6c2460             | mov                 ebp, dword ptr [esp + 0x60]
            //   33ff                 | xor                 edi, edi
            //   8b5c2430             | mov                 ebx, dword ptr [esp + 0x30]
            //   8bc7                 | mov                 eax, edi
            //   47                   | inc                 edi
            //   99                   | cdq                 

        $sequence_8 = { 89442478 8b4108 8944247c 8b410c 89842480000000 8b4910 8b842484000000 }
            // n = 7, score = 100
            //   89442478             | mov                 dword ptr [esp + 0x78], eax
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   8944247c             | mov                 dword ptr [esp + 0x7c], eax
            //   8b410c               | mov                 eax, dword ptr [ecx + 0xc]
            //   89842480000000       | mov                 dword ptr [esp + 0x80], eax
            //   8b4910               | mov                 ecx, dword ptr [ecx + 0x10]
            //   8b842484000000       | mov                 eax, dword ptr [esp + 0x84]

        $sequence_9 = { ff7620 55 e8???????? 83c40c 85c0 0f8480feffff 53 }
            // n = 7, score = 100
            //   ff7620               | push                dword ptr [esi + 0x20]
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f8480feffff         | je                  0xfffffe86
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 2455552
}