rule win_hermeticwiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hermeticwiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hermeticwiper"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c414 85db 7410 53 6a00 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85db                 | test                ebx, ebx
            //   7410                 | je                  0x12
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_1 = { 8bcb e8???????? 8b4c2410 83c404 8b442410 894f0c }
            // n = 6, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   83c404               | add                 esp, 4
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   894f0c               | mov                 dword ptr [edi + 0xc], ecx

        $sequence_2 = { 53 56 57 f60010 c745f8???????? c745fc???????? }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   f60010               | test                byte ptr [eax], 0x10
            //   c745f8????????       |                     
            //   c745fc????????       |                     

        $sequence_3 = { 8bf2 8bc3 0facc605 8975cc c1e805 8945e4 83e107 }
            // n = 7, score = 200
            //   8bf2                 | mov                 esi, edx
            //   8bc3                 | mov                 eax, ebx
            //   0facc605             | shrd                esi, eax, 5
            //   8975cc               | mov                 dword ptr [ebp - 0x34], esi
            //   c1e805               | shr                 eax, 5
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   83e107               | and                 ecx, 7

        $sequence_4 = { 85f6 0f84ee030000 56 ff35???????? }
            // n = 4, score = 200
            //   85f6                 | test                esi, esi
            //   0f84ee030000         | je                  0x3f4
            //   56                   | push                esi
            //   ff35????????         |                     

        $sequence_5 = { 8b4e10 8b7e08 03cf 8b560c 8b4614 13c2 89542418 }
            // n = 7, score = 200
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]
            //   03cf                 | add                 ecx, edi
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   13c2                 | adc                 eax, edx
            //   89542418             | mov                 dword ptr [esp + 0x18], edx

        $sequence_6 = { 8d8578fcffff 50 ff15???????? 8d8578fcffff 50 ff15???????? 8d8578fcffff }
            // n = 7, score = 200
            //   8d8578fcffff         | lea                 eax, [ebp - 0x388]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d8578fcffff         | lea                 eax, [ebp - 0x388]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d8578fcffff         | lea                 eax, [ebp - 0x388]

        $sequence_7 = { 897004 8b451c 895e0c c7460800000000 85c0 7506 8b4518 }
            // n = 7, score = 200
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   895e0c               | mov                 dword ptr [esi + 0xc], ebx
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]

        $sequence_8 = { 8bf7 8955f8 894dfc 03f1 }
            // n = 4, score = 200
            //   8bf7                 | mov                 esi, edi
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   03f1                 | add                 esi, ecx

        $sequence_9 = { 8b542418 837b3400 7406 895340 }
            // n = 4, score = 200
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   837b3400             | cmp                 dword ptr [ebx + 0x34], 0
            //   7406                 | je                  8
            //   895340               | mov                 dword ptr [ebx + 0x40], edx

    condition:
        7 of them and filesize < 247808
}