rule win_hikit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hikit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hikit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d542414 52 895c2418 e8???????? 83c404 3bc3 741a }
            // n = 7, score = 100
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   52                   | push                edx
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3bc3                 | cmp                 eax, ebx
            //   741a                 | je                  0x1c

        $sequence_1 = { 0fbe84c188e30110 6a07 c1f804 59 8985a4fbffff 3bc1 }
            // n = 6, score = 100
            //   0fbe84c188e30110     | movsx               eax, byte ptr [ecx + eax*8 + 0x1001e388]
            //   6a07                 | push                7
            //   c1f804               | sar                 eax, 4
            //   59                   | pop                 ecx
            //   8985a4fbffff         | mov                 dword ptr [ebp - 0x45c], eax
            //   3bc1                 | cmp                 eax, ecx

        $sequence_2 = { 895dfc 89450c ffd7 3bc3 7407 8b4d0c }
            // n = 6, score = 100
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   ffd7                 | call                edi
            //   3bc3                 | cmp                 eax, ebx
            //   7407                 | je                  9
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_3 = { 8bf0 85f6 7505 5e 5f 5d 59 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7505                 | jne                 7
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   59                   | pop                 ecx

        $sequence_4 = { 48 8b4c2420 48 8b4910 ff90d0020000 48 }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   48                   | dec                 eax
            //   8b4910               | mov                 ecx, dword ptr [ecx + 0x10]
            //   ff90d0020000         | call                dword ptr [eax + 0x2d0]
            //   48                   | dec                 eax

        $sequence_5 = { 4c 8b4c2478 4c 8b442470 4d 8b4018 48 }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   8b4c2478             | mov                 ecx, dword ptr [esp + 0x78]
            //   4c                   | dec                 esp
            //   8b442470             | mov                 eax, dword ptr [esp + 0x70]
            //   4d                   | dec                 ebp
            //   8b4018               | mov                 eax, dword ptr [eax + 0x18]
            //   48                   | dec                 eax

        $sequence_6 = { 817c241018031120 751d 8b442414 83e801 750a 8d4c2410 51 }
            // n = 7, score = 100
            //   817c241018031120     | cmp                 dword ptr [esp + 0x10], 0x20110318
            //   751d                 | jne                 0x1f
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   83e801               | sub                 eax, 1
            //   750a                 | jne                 0xc
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx

        $sequence_7 = { 8d4c2420 ff15???????? 89442438 837c243800 7405 e9???????? 48 }
            // n = 7, score = 100
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   ff15????????         |                     
            //   89442438             | mov                 dword ptr [esp + 0x38], eax
            //   837c243800           | cmp                 dword ptr [esp + 0x38], 0
            //   7405                 | je                  7
            //   e9????????           |                     
            //   48                   | dec                 eax

        $sequence_8 = { 56 ff15???????? b001 eb08 ff15???????? 32c0 5f }
            // n = 7, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   b001                 | mov                 al, 1
            //   eb08                 | jmp                 0xa
            //   ff15????????         |                     
            //   32c0                 | xor                 al, al
            //   5f                   | pop                 edi

        $sequence_9 = { e9???????? 48 8b842468010000 0fb600 240f 0fb6c0 c1e002 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   48                   | dec                 eax
            //   8b842468010000       | mov                 eax, dword ptr [esp + 0x168]
            //   0fb600               | movzx               eax, byte ptr [eax]
            //   240f                 | and                 al, 0xf
            //   0fb6c0               | movzx               eax, al
            //   c1e002               | shl                 eax, 2

    condition:
        7 of them and filesize < 573440
}