rule win_hoplight_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hoplight."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hoplight"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bcf ff15???????? 488d442430 4c8d442440 4533c9 33d2 }
            // n = 6, score = 100
            //   488bcf               | lea                 edx, [esp + 0x20]
            //   ff15????????         |                     
            //   488d442430           | dec                 eax
            //   4c8d442440           | mov                 ecx, eax
            //   4533c9               | mov                 dword ptr [esp + 0x20], 0x238
            //   33d2                 | dec                 eax

        $sequence_1 = { 488d942428010000 488d4c2440 e8???????? 488d8c2450010000 e8???????? 488b842450020000 }
            // n = 6, score = 100
            //   488d942428010000     | xor                 ecx, ecx
            //   488d4c2440           | xor                 edx, edx
            //   e8????????           |                     
            //   488d8c2450010000     | dec                 eax
            //   e8????????           |                     
            //   488b842450020000     | arpl                word ptr [esp + 0x20], ax

        $sequence_2 = { 0bc1 25ff000000 89842410040000 8b842410040000 83f063 8b8c2414040000 }
            // n = 6, score = 100
            //   0bc1                 | dec                 eax
            //   25ff000000           | lea                 ecx, [esp + 0x150]
            //   89842410040000       | dec                 eax
            //   8b842410040000       | mov                 eax, dword ptr [esp + 0x250]
            //   83f063               | dec                 eax
            //   8b8c2414040000       | mov                 eax, dword ptr [esp + 0x98]

        $sequence_3 = { 4863442420 488b4c2470 8b848138100000 89442424 4863442424 488b4c2448 }
            // n = 6, score = 100
            //   4863442420           | mov                 ecx, edi
            //   488b4c2470           | dec                 eax
            //   8b848138100000       | lea                 eax, [esp + 0x30]
            //   89442424             | dec                 esp
            //   4863442424           | lea                 eax, [esp + 0x40]
            //   488b4c2448           | inc                 ebp

        $sequence_4 = { 48638c2484040000 486bc910 488d4c0c40 488d942440040000 4889542420 448b8c2454040000 }
            // n = 6, score = 100
            //   48638c2484040000     | dec                 eax
            //   486bc910             | mov                 ecx, dword ptr [esp + 0x48]
            //   488d4c0c40           | dec                 eax
            //   488d942440040000     | lea                 edx, [esp + 0x128]
            //   4889542420           | dec                 eax
            //   448b8c2454040000     | lea                 ecx, [esp + 0x40]

        $sequence_5 = { 4883f8ff 7443 488d542420 488bc8 c744242038020000 ff15???????? }
            // n = 6, score = 100
            //   4883f8ff             | shr                 ecx, 0x18
            //   7443                 | dec                 eax
            //   488d542420           | cmp                 eax, -1
            //   488bc8               | je                  0x45
            //   c744242038020000     | dec                 eax
            //   ff15????????         |                     

        $sequence_6 = { 488b842498000000 48898424a8000000 488b8424c8000000 4889842498000000 488b8424a8000000 8b00 }
            // n = 6, score = 100
            //   488b842498000000     | dec                 eax
            //   48898424a8000000     | mov                 ecx, dword ptr [esp + 0x70]
            //   488b8424c8000000     | mov                 eax, dword ptr [ecx + eax*4 + 0x1038]
            //   4889842498000000     | mov                 dword ptr [esp + 0x24], eax
            //   488b8424a8000000     | dec                 eax
            //   8b00                 | arpl                word ptr [esp + 0x24], ax

        $sequence_7 = { 81e1ff000000 8bc9 488d15966d0200 33048a 8b4c2428 c1e918 }
            // n = 6, score = 100
            //   81e1ff000000         | and                 ecx, 0xff
            //   8bc9                 | mov                 ecx, ecx
            //   488d15966d0200       | dec                 eax
            //   33048a               | lea                 edx, [0x26d96]
            //   8b4c2428             | xor                 eax, dword ptr [edx + ecx*4]
            //   c1e918               | mov                 ecx, dword ptr [esp + 0x28]

    condition:
        7 of them and filesize < 765952
}