rule win_hotcroissant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hotcroissant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hotcroissant"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7409 6a01 50 ff15???????? 68???????? }
            // n = 6, score = 600
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_1 = { 68703a0000 8d958cc5ffff 52 50 }
            // n = 4, score = 600
            //   68703a0000           | push                0x3a70
            //   8d958cc5ffff         | lea                 edx, [ebp - 0x3a74]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_2 = { 33c0 52 a3???????? a3???????? a3???????? a3???????? }
            // n = 6, score = 600
            //   33c0                 | xor                 eax, eax
            //   52                   | push                edx
            //   a3????????           |                     
            //   a3????????           |                     
            //   a3????????           |                     
            //   a3????????           |                     

        $sequence_3 = { 33ff 3bc7 7473 56 }
            // n = 4, score = 600
            //   33ff                 | xor                 edi, edi
            //   3bc7                 | cmp                 eax, edi
            //   7473                 | je                  0x75
            //   56                   | push                esi

        $sequence_4 = { 7409 6a01 50 ff15???????? 68???????? }
            // n = 5, score = 600
            //   7409                 | je                  0xb
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_5 = { c1e808 46 0bc7 8955fc 3b750c }
            // n = 5, score = 600
            //   c1e808               | shr                 eax, 8
            //   46                   | inc                 esi
            //   0bc7                 | or                  eax, edi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   3b750c               | cmp                 esi, dword ptr [ebp + 0xc]

        $sequence_6 = { 8b7d08 8a1c3e 32da 32d8 32d9 881c3e 8ad8 }
            // n = 7, score = 600
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8a1c3e               | mov                 bl, byte ptr [esi + edi]
            //   32da                 | xor                 bl, dl
            //   32d8                 | xor                 bl, al
            //   32d9                 | xor                 bl, cl
            //   881c3e               | mov                 byte ptr [esi + edi], bl
            //   8ad8                 | mov                 bl, al

        $sequence_7 = { 7473 56 6a01 50 }
            // n = 4, score = 600
            //   7473                 | je                  0x75
            //   56                   | push                esi
            //   6a01                 | push                1
            //   50                   | push                eax

        $sequence_8 = { a3???????? a3???????? ffd6 a1???????? 50 ffd6 }
            // n = 6, score = 600
            //   a3????????           |                     
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   a1????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_9 = { a3???????? a3???????? a3???????? ffd6 a1???????? 50 }
            // n = 6, score = 600
            //   a3????????           |                     
            //   a3????????           |                     
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   a1????????           |                     
            //   50                   | push                eax

    condition:
        7 of them and filesize < 591872
}