rule win_httpbrowser_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.httpbrowser."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.httpbrowser"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8d85fcedffff 6a00 50 e8???????? 53 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   8d85fcedffff         | lea                 eax, [ebp - 0x1204]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_1 = { a3???????? 3bfe 7459 68???????? 68???????? e8???????? 59 }
            // n = 7, score = 200
            //   a3????????           |                     
            //   3bfe                 | cmp                 edi, esi
            //   7459                 | je                  0x5b
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { 75f9 6a00 2bc1 8d4dfc 51 }
            // n = 5, score = 200
            //   75f9                 | jne                 0xfffffffb
            //   6a00                 | push                0
            //   2bc1                 | sub                 eax, ecx
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx

        $sequence_3 = { e8???????? 83c40c ff15???????? 8985ecfeffff }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff15????????         |                     
            //   8985ecfeffff         | mov                 dword ptr [ebp - 0x114], eax

        $sequence_4 = { 6a00 50 e8???????? 83c418 8d856853ffff 50 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8d856853ffff         | lea                 eax, [ebp - 0xac98]
            //   50                   | push                eax

        $sequence_5 = { ffb538eeffff ff15???????? 85c0 744a 53 53 ffb52ceeffff }
            // n = 7, score = 200
            //   ffb538eeffff         | push                dword ptr [ebp - 0x11c8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   744a                 | je                  0x4c
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ffb52ceeffff         | push                dword ptr [ebp - 0x11d4]

        $sequence_6 = { 33c9 41 6a06 66898de8fdffff }
            // n = 4, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   41                   | inc                 ecx
            //   6a06                 | push                6
            //   66898de8fdffff       | mov                 word ptr [ebp - 0x218], cx

        $sequence_7 = { 56 ff15???????? 8985e0fbffff 3bc6 7428 56 56 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8985e0fbffff         | mov                 dword ptr [ebp - 0x420], eax
            //   3bc6                 | cmp                 eax, esi
            //   7428                 | je                  0x2a
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_8 = { 33d2 b9ff010000 33c0 8dbd5af2ffff }
            // n = 4, score = 100
            //   33d2                 | xor                 edx, edx
            //   b9ff010000           | mov                 ecx, 0x1ff
            //   33c0                 | xor                 eax, eax
            //   8dbd5af2ffff         | lea                 edi, [ebp - 0xda6]

        $sequence_9 = { 8b55fc 8a92704d4100 0890a1524100 40 3bc7 76f5 41 }
            // n = 7, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8a92704d4100         | mov                 dl, byte ptr [edx + 0x414d70]
            //   0890a1524100         | or                  byte ptr [eax + 0x4152a1], dl
            //   40                   | inc                 eax
            //   3bc7                 | cmp                 eax, edi
            //   76f5                 | jbe                 0xfffffff7
            //   41                   | inc                 ecx

        $sequence_10 = { 5d 8a4c15b8 884dec 8b45ec }
            // n = 4, score = 100
            //   5d                   | pop                 ebp
            //   8a4c15b8             | mov                 cl, byte ptr [ebp + edx - 0x48]
            //   884dec               | mov                 byte ptr [ebp - 0x14], cl
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_11 = { 5d 5d 9d 5d 8b4510 }
            // n = 5, score = 100
            //   5d                   | pop                 ebp
            //   5d                   | pop                 ebp
            //   9d                   | popfd               
            //   5d                   | pop                 ebp
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_12 = { 50 ff15???????? 83c410 68???????? 55 8bec 9c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   68????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   9c                   | pushfd              

        $sequence_13 = { 5d 8d9544f3ffff 8d854453ffff 52 }
            // n = 4, score = 100
            //   5d                   | pop                 ebp
            //   8d9544f3ffff         | lea                 edx, [ebp - 0xcbc]
            //   8d854453ffff         | lea                 eax, [ebp - 0xacbc]
            //   52                   | push                edx

        $sequence_14 = { 58 b900020000 33c0 8dbdf8f7ffff f3ab 50 50 }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   b900020000           | mov                 ecx, 0x200
            //   33c0                 | xor                 eax, eax
            //   8dbdf8f7ffff         | lea                 edi, [ebp - 0x808]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_15 = { 57 83f9ff 7414 8bf9 c1ff05 83e11f 8b3cbd00644100 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   83f9ff               | cmp                 ecx, -1
            //   7414                 | je                  0x16
            //   8bf9                 | mov                 edi, ecx
            //   c1ff05               | sar                 edi, 5
            //   83e11f               | and                 ecx, 0x1f
            //   8b3cbd00644100       | mov                 edi, dword ptr [edi*4 + 0x416400]

    condition:
        7 of them and filesize < 188416
}