rule win_huskloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.huskloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.huskloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc7 83e03f 6bc838 8b0495e88d0110 }
            // n = 4, score = 100
            //   8bc7                 | mov                 eax, edi
            //   83e03f               | and                 eax, 0x3f
            //   6bc838               | imul                ecx, eax, 0x38
            //   8b0495e88d0110       | mov                 eax, dword ptr [edx*4 + 0x10018de8]

        $sequence_1 = { 59 e9???????? c745e003000000 e9???????? c745e4c05e0110 ebb8 d9e8 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   c745e003000000       | mov                 dword ptr [ebp - 0x20], 3
            //   e9????????           |                     
            //   c745e4c05e0110       | mov                 dword ptr [ebp - 0x1c], 0x10015ec0
            //   ebb8                 | jmp                 0xffffffba
            //   d9e8                 | fld1                

        $sequence_2 = { 6a00 681f000f00 50 ff15???????? 85c0 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   681f000f00           | push                0xf001f
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 740e 50 e8???????? 83a6e88d011000 59 83c604 81fe00020000 }
            // n = 7, score = 100
            //   740e                 | je                  0x10
            //   50                   | push                eax
            //   e8????????           |                     
            //   83a6e88d011000       | and                 dword ptr [esi + 0x10018de8], 0
            //   59                   | pop                 ecx
            //   83c604               | add                 esi, 4
            //   81fe00020000         | cmp                 esi, 0x200

        $sequence_4 = { 8d043b 8b3485601f0110 8d4601 8945fc 8a06 46 }
            // n = 6, score = 100
            //   8d043b               | lea                 eax, [ebx + edi]
            //   8b3485601f0110       | mov                 esi, dword ptr [eax*4 + 0x10011f60]
            //   8d4601               | lea                 eax, [esi + 1]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8a06                 | mov                 al, byte ptr [esi]
            //   46                   | inc                 esi

        $sequence_5 = { 57 8bb81c060000 6a40 6800300000 56 6a00 ff15???????? }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bb81c060000         | mov                 edi, dword ptr [eax + 0x61c]
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_6 = { 85c0 7411 8b35???????? b98b010000 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   8b35????????         |                     
            //   b98b010000           | mov                 ecx, 0x18b

        $sequence_7 = { 7420 6bc618 57 8db8288c0110 57 ff15???????? }
            // n = 6, score = 100
            //   7420                 | je                  0x22
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8288c0110         | lea                 edi, [eax + 0x10018c28]
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_8 = { 8b35???????? 85f6 7420 6bc618 57 8db8288c0110 57 }
            // n = 7, score = 100
            //   8b35????????         |                     
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8288c0110         | lea                 edi, [eax + 0x10018c28]
            //   57                   | push                edi

        $sequence_9 = { 0fb704850c3b0110 8d048508320110 50 8d8590faffff 03c7 50 }
            // n = 6, score = 100
            //   0fb704850c3b0110     | movzx               eax, word ptr [eax*4 + 0x10013b0c]
            //   8d048508320110       | lea                 eax, [eax*4 + 0x10013208]
            //   50                   | push                eax
            //   8d8590faffff         | lea                 eax, [ebp - 0x570]
            //   03c7                 | add                 eax, edi
            //   50                   | push                eax

    condition:
        7 of them and filesize < 229376
}