rule win_invisimole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.invisimole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.invisimole"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 33c9 57 66890b ff15???????? 6a10 6a00 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   33c9                 | xor                 ecx, ecx
            //   57                   | push                edi
            //   66890b               | mov                 word ptr [ebx], cx
            //   ff15????????         |                     
            //   6a10                 | push                0x10
            //   6a00                 | push                0

        $sequence_1 = { 8d4de4 51 8d88980f0000 51 c745eca8a94000 8955f0 c745f41e000000 }
            // n = 7, score = 100
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   51                   | push                ecx
            //   8d88980f0000         | lea                 ecx, [eax + 0xf98]
            //   51                   | push                ecx
            //   c745eca8a94000       | mov                 dword ptr [ebp - 0x14], 0x40a9a8
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   c745f41e000000       | mov                 dword ptr [ebp - 0xc], 0x1e

        $sequence_2 = { ff15???????? 8b55f4 53 33c9 52 66890f }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   53                   | push                ebx
            //   33c9                 | xor                 ecx, ecx
            //   52                   | push                edx
            //   66890f               | mov                 word ptr [edi], cx

        $sequence_3 = { 8bc1 0f848e110000 8d4dc8 51 8d75fc e8???????? 8bf0 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   0f848e110000         | je                  0x1194
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   51                   | push                ecx
            //   8d75fc               | lea                 esi, [ebp - 4]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 8b7d8c 85ff 7450 33f6 3975ac 7628 83c704 }
            // n = 7, score = 100
            //   8b7d8c               | mov                 edi, dword ptr [ebp - 0x74]
            //   85ff                 | test                edi, edi
            //   7450                 | je                  0x52
            //   33f6                 | xor                 esi, esi
            //   3975ac               | cmp                 dword ptr [ebp - 0x54], esi
            //   7628                 | jbe                 0x2a
            //   83c704               | add                 edi, 4

        $sequence_5 = { c645bc0d 668955bd 894dbf 8bde 7409 83c302 66833b2a }
            // n = 7, score = 100
            //   c645bc0d             | mov                 byte ptr [ebp - 0x44], 0xd
            //   668955bd             | mov                 word ptr [ebp - 0x43], dx
            //   894dbf               | mov                 dword ptr [ebp - 0x41], ecx
            //   8bde                 | mov                 ebx, esi
            //   7409                 | je                  0xb
            //   83c302               | add                 ebx, 2
            //   66833b2a             | cmp                 word ptr [ebx], 0x2a

        $sequence_6 = { e8???????? 0fb64636 6a01 8d4dff 51 57 8845ff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb64636             | movzx               eax, byte ptr [esi + 0x36]
            //   6a01                 | push                1
            //   8d4dff               | lea                 ecx, [ebp - 1]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   8845ff               | mov                 byte ptr [ebp - 1], al

        $sequence_7 = { c7464c00000080 c703ffffffff c6466c00 ff15???????? 8d55f0 52 }
            // n = 6, score = 100
            //   c7464c00000080       | mov                 dword ptr [esi + 0x4c], 0x80000000
            //   c703ffffffff         | mov                 dword ptr [ebx], 0xffffffff
            //   c6466c00             | mov                 byte ptr [esi + 0x6c], 0
            //   ff15????????         |                     
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx

        $sequence_8 = { 53 56 ff15???????? 85c0 0f8595000000 3975fc 0f848c000000 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8595000000         | jne                 0x9b
            //   3975fc               | cmp                 dword ptr [ebp - 4], esi
            //   0f848c000000         | je                  0x92

        $sequence_9 = { ff15???????? 8b4c2414 668944cf04 8b44241c 41 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   668944cf04           | mov                 word ptr [edi + ecx*8 + 4], ax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   41                   | inc                 ecx

    condition:
        7 of them and filesize < 139264
}