rule win_jessiecontea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.jessiecontea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jessiecontea"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 ff15???????? 8b4dfc 83c414 8bc6 }
            // n = 5, score = 300
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c414               | add                 esp, 0x14
            //   8bc6                 | mov                 eax, esi

        $sequence_1 = { 83f8ff 0f8411020000 8b3d???????? 6683bdc0fbffff2e }
            // n = 4, score = 300
            //   83f8ff               | cmp                 eax, -1
            //   0f8411020000         | je                  0x217
            //   8b3d????????         |                     
            //   6683bdc0fbffff2e     | cmp                 word ptr [ebp - 0x440], 0x2e

        $sequence_2 = { 3d04010000 7d8f 6a00 6a00 50 }
            // n = 5, score = 300
            //   3d04010000           | cmp                 eax, 0x104
            //   7d8f                 | jge                 0xffffff91
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_3 = { 50 8d043e 50 ff35???????? }
            // n = 4, score = 300
            //   50                   | push                eax
            //   8d043e               | lea                 eax, [esi + edi]
            //   50                   | push                eax
            //   ff35????????         |                     

        $sequence_4 = { 57 89bd8cfbffff 898590fbffff ffd6 3d00010000 }
            // n = 5, score = 300
            //   57                   | push                edi
            //   89bd8cfbffff         | mov                 dword ptr [ebp - 0x474], edi
            //   898590fbffff         | mov                 dword ptr [ebp - 0x470], eax
            //   ffd6                 | call                esi
            //   3d00010000           | cmp                 eax, 0x100

        $sequence_5 = { 51 85c0 7406 83c002 50 eb01 57 }
            // n = 7, score = 300
            //   51                   | push                ecx
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   83c002               | add                 eax, 2
            //   50                   | push                eax
            //   eb01                 | jmp                 3
            //   57                   | push                edi

        $sequence_6 = { 8d95acf3ffff 8bce e8???????? 83c404 85c0 }
            // n = 5, score = 300
            //   8d95acf3ffff         | lea                 edx, [ebp - 0xc54]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax

        $sequence_7 = { 83c40c 8d85e8fdffff 6805010000 6a00 }
            // n = 4, score = 300
            //   83c40c               | add                 esp, 0xc
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   6805010000           | push                0x105
            //   6a00                 | push                0

        $sequence_8 = { 6689953e010000 66898540010000 b823000000 6689b542010000 6644899544010000 66898546010000 }
            // n = 6, score = 100
            //   6689953e010000       | mov                 word ptr [ebp + 0x13e], dx
            //   66898540010000       | mov                 word ptr [ebp + 0x140], ax
            //   b823000000           | mov                 eax, 0x23
            //   6689b542010000       | mov                 word ptr [ebp + 0x142], si
            //   6644899544010000     | inc                 sp
            //   66898546010000       | mov                 dword ptr [ebp + 0x144], edx

        $sequence_9 = { 6689857e010000 8b05???????? 4133c6 66898580010000 0fb705???????? }
            // n = 5, score = 100
            //   6689857e010000       | add                 ax, 0x12
            //   8b05????????         |                     
            //   4133c6               | add                 ax, 0x32
            //   66898580010000       | xor                 eax, 0x3b
            //   0fb705????????       |                     

        $sequence_10 = { 57 488bec 4883ec68 8b3d???????? 4c8d4d18 33c0 }
            // n = 6, score = 100
            //   57                   | mov                 word ptr [ebp + 0x146], ax
            //   488bec               | push                edi
            //   4883ec68             | dec                 eax
            //   8b3d????????         |                     
            //   4c8d4d18             | mov                 ebp, esp
            //   33c0                 | dec                 eax

        $sequence_11 = { 4889442420 4c8d4580 418d5601 ff15???????? 488b5580 }
            // n = 5, score = 100
            //   4889442420           | inc                 ecx
            //   4c8d4580             | xor                 eax, esi
            //   418d5601             | mov                 word ptr [ebp + 0x180], ax
            //   ff15????????         |                     
            //   488b5580             | dec                 eax

        $sequence_12 = { 4889442420 4533c9 8974247c 4c8d4590 48895d98 }
            // n = 5, score = 100
            //   4889442420           | mov                 word ptr [ebp + 0x28], ax
            //   4533c9               | mov                 eax, dword ptr [ebp - 0x40]
            //   8974247c             | add                 ax, 0x33
            //   4c8d4590             | xor                 eax, 0x20
            //   48895d98             | mov                 word ptr [ebp + 0x17e], ax

        $sequence_13 = { 6683c032 83f03b 66894528 8b45c0 6683c033 83f020 }
            // n = 6, score = 100
            //   6683c032             | inc                 sp
            //   83f03b               | mov                 dword ptr [ebp - 0x80], esp
            //   66894528             | mov                 dword ptr [ebp - 0x7c], eax
            //   8b45c0               | xor                 eax, ecx
            //   6683c033             | mov                 word ptr [esp + 0x76], ax
            //   83f020               | mov                 eax, dword ptr [esp + 0x50]

        $sequence_14 = { 4c89a424e8020000 41bc02000000 6644896580 894584 ff15???????? }
            // n = 5, score = 100
            //   4c89a424e8020000     | sub                 esp, 0x68
            //   41bc02000000         | dec                 esp
            //   6644896580           | lea                 ecx, [ebp + 0x18]
            //   894584               | xor                 eax, eax
            //   ff15????????         |                     

        $sequence_15 = { 33c1 6689442476 8b442450 6683c012 }
            // n = 4, score = 100
            //   33c1                 | dec                 esp
            //   6689442476           | mov                 dword ptr [esp + 0x2e8], esp
            //   8b442450             | inc                 ecx
            //   6683c012             | mov                 esp, 2

    condition:
        7 of them and filesize < 413696
}