rule win_jlorat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.jlorat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jlorat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7004 e8???????? 83c40c 8b45e8 64a300000000 83c414 5e }
            // n = 7, score = 200
            //   ff7004               | push                dword ptr [eax + 4]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   83c414               | add                 esp, 0x14
            //   5e                   | pop                 esi

        $sequence_1 = { f20f118620010000 c786c801000004000000 89e0 8d8e20010000 894804 8d8e08010000 8908 }
            // n = 7, score = 200
            //   f20f118620010000     | movsd               qword ptr [esi + 0x120], xmm0
            //   c786c801000004000000     | mov    dword ptr [esi + 0x1c8], 4
            //   89e0                 | mov                 eax, esp
            //   8d8e20010000         | lea                 ecx, [esi + 0x120]
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8d8e08010000         | lea                 ecx, [esi + 0x108]
            //   8908                 | mov                 dword ptr [eax], ecx

        $sequence_2 = { f20f1145c4 894dd0 8945d4 c745f000000000 89e0 c7400404000000 c70014000000 }
            // n = 7, score = 200
            //   f20f1145c4           | movsd               qword ptr [ebp - 0x3c], xmm0
            //   894dd0               | mov                 dword ptr [ebp - 0x30], ecx
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   89e0                 | mov                 eax, esp
            //   c7400404000000       | mov                 dword ptr [eax + 4], 4
            //   c70014000000         | mov                 dword ptr [eax], 0x14

        $sequence_3 = { e9???????? 8b3424 897c242c 8bbc2418020000 83ff29 0f8339090000 85ff }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8b3424               | mov                 esi, dword ptr [esp]
            //   897c242c             | mov                 dword ptr [esp + 0x2c], edi
            //   8bbc2418020000       | mov                 edi, dword ptr [esp + 0x218]
            //   83ff29               | cmp                 edi, 0x29
            //   0f8339090000         | jae                 0x93f
            //   85ff                 | test                edi, edi

        $sequence_4 = { f20f118eb00e0000 f20f1186a80e0000 8b86b80e0000 8986d00e0000 f20f1086a80e0000 f20f108eb00e0000 f20f118ec80e0000 }
            // n = 7, score = 200
            //   f20f118eb00e0000     | movsd               qword ptr [esi + 0xeb0], xmm1
            //   f20f1186a80e0000     | movsd               qword ptr [esi + 0xea8], xmm0
            //   8b86b80e0000         | mov                 eax, dword ptr [esi + 0xeb8]
            //   8986d00e0000         | mov                 dword ptr [esi + 0xed0], eax
            //   f20f1086a80e0000     | movsd               xmm0, qword ptr [esi + 0xea8]
            //   f20f108eb00e0000     | movsd               xmm1, qword ptr [esi + 0xeb0]
            //   f20f118ec80e0000     | movsd               qword ptr [esi + 0xec8], xmm1

        $sequence_5 = { eb00 8b8d6cffffff 8b8558ffffff 8945d0 89e0 8908 e8???????? }
            // n = 7, score = 200
            //   eb00                 | jmp                 2
            //   8b8d6cffffff         | mov                 ecx, dword ptr [ebp - 0x94]
            //   8b8558ffffff         | mov                 eax, dword ptr [ebp - 0xa8]
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   89e0                 | mov                 eax, esp
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     

        $sequence_6 = { c745f000000000 89e0 8d4da8 8908 e8???????? eb00 8b855cffffff }
            // n = 7, score = 200
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   89e0                 | mov                 eax, esp
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     
            //   eb00                 | jmp                 2
            //   8b855cffffff         | mov                 eax, dword ptr [ebp - 0xa4]

        $sequence_7 = { 8b4d0c 51 8b5508 52 e8???????? 83c40c 0fb64510 }
            // n = 7, score = 200
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   0fb64510             | movzx               eax, byte ptr [ebp + 0x10]

        $sequence_8 = { f6861701000001 7552 8b8e10010000 89e0 894804 8d8e48010000 898efc000000 }
            // n = 7, score = 200
            //   f6861701000001       | test                byte ptr [esi + 0x117], 1
            //   7552                 | jne                 0x54
            //   8b8e10010000         | mov                 ecx, dword ptr [esi + 0x110]
            //   89e0                 | mov                 eax, esp
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8d8e48010000         | lea                 ecx, [esi + 0x148]
            //   898efc000000         | mov                 dword ptr [esi + 0xfc], ecx

        $sequence_9 = { eb00 8b4de0 83c140 c745f002000000 89e0 8908 e8???????? }
            // n = 7, score = 200
            //   eb00                 | jmp                 2
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   83c140               | add                 ecx, 0x40
            //   c745f002000000       | mov                 dword ptr [ebp - 0x10], 2
            //   89e0                 | mov                 eax, esp
            //   8908                 | mov                 dword ptr [eax], ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 10952704
}