rule win_jripbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.jripbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jripbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc6 c1c007 33d0 8bc6 c1c806 33d0 8b459c }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1c007               | rol                 eax, 7
            //   33d0                 | xor                 edx, eax
            //   8bc6                 | mov                 eax, esi
            //   c1c806               | ror                 eax, 6
            //   33d0                 | xor                 edx, eax
            //   8b459c               | mov                 eax, dword ptr [ebp - 0x64]

        $sequence_1 = { ffd6 b9???????? 8bc1 83c430 8d5002 668b30 }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   b9????????           |                     
            //   8bc1                 | mov                 eax, ecx
            //   83c430               | add                 esp, 0x30
            //   8d5002               | lea                 edx, [eax + 2]
            //   668b30               | mov                 si, word ptr [eax]

        $sequence_2 = { eb0e c7060c000000 eb06 c7060a000000 8b4d0c c1e905 53 }
            // n = 7, score = 100
            //   eb0e                 | jmp                 0x10
            //   c7060c000000         | mov                 dword ptr [esi], 0xc
            //   eb06                 | jmp                 8
            //   c7060a000000         | mov                 dword ptr [esi], 0xa
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   c1e905               | shr                 ecx, 5
            //   53                   | push                ebx

        $sequence_3 = { 83a7a400000000 6a08 59 8b8780000000 8d4401ff fe00 7503 }
            // n = 7, score = 100
            //   83a7a400000000       | and                 dword ptr [edi + 0xa4], 0
            //   6a08                 | push                8
            //   59                   | pop                 ecx
            //   8b8780000000         | mov                 eax, dword ptr [edi + 0x80]
            //   8d4401ff             | lea                 eax, [ecx + eax - 1]
            //   fe00                 | inc                 byte ptr [eax]
            //   7503                 | jne                 5

        $sequence_4 = { ff75e8 ffd7 be???????? e8???????? 8d5002 668b08 83c002 }
            // n = 7, score = 100
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ffd7                 | call                edi
            //   be????????           |                     
            //   e8????????           |                     
            //   8d5002               | lea                 edx, [eax + 2]
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2

        $sequence_5 = { 8b9554ffffff c1c20e c1cb07 33d3 8b9d54ffffff c1eb03 33d3 }
            // n = 7, score = 100
            //   8b9554ffffff         | mov                 edx, dword ptr [ebp - 0xac]
            //   c1c20e               | rol                 edx, 0xe
            //   c1cb07               | ror                 ebx, 7
            //   33d3                 | xor                 edx, ebx
            //   8b9d54ffffff         | mov                 ebx, dword ptr [ebp - 0xac]
            //   c1eb03               | shr                 ebx, 3
            //   33d3                 | xor                 edx, ebx

        $sequence_6 = { 83ec0c 53 33c0 56 57 be???????? }
            // n = 6, score = 100
            //   83ec0c               | sub                 esp, 0xc
            //   53                   | push                ebx
            //   33c0                 | xor                 eax, eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   be????????           |                     

        $sequence_7 = { eb16 ff7518 8b4d08 ff7514 ff7510 52 8b550c }
            // n = 7, score = 100
            //   eb16                 | jmp                 0x18
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_8 = { 8bf0 83c408 85f6 7412 53 e8???????? 59 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   7412                 | je                  0x14
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_9 = { 8bf8 85ff 7410 ff7508 56 57 }
            // n = 6, score = 100
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7410                 | je                  0x12
            //   ff7508               | push                dword ptr [ebp + 8]
            //   56                   | push                esi
            //   57                   | push                edi

    condition:
        7 of them and filesize < 507904
}